/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.openapi.project.Project;
import com.intellij.util.ProfilingUtil;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.Profiler;
import org.jetbrains.annotations.NotNull;

public class ProfilersController {
    private boolean stoppedByScript = false;
    private Profiler currentProfilerHandler;
    private static ProfilersController instance;
    private String reportsPath;

    private ProfilersController() {
    }

    public static synchronized ProfilersController getInstance() {
        if (instance == null) {
            instance = new ProfilersController();
        }
        return instance;
    }

    public void setCurrentProfiler(Profiler profilerHandler) {
        this.currentProfilerHandler = profilerHandler;
        this.stoppedByScript = false;
        this.reportsPath = null;
    }

    public Profiler getCurrentProfilerHandler() {
        return this.currentProfilerHandler;
    }

    public boolean isProfilingStarted(@NotNull Project project) {
        if (project == null) {
            ProfilersController.$$$reportNull$$$0(0);
        }
        return ProfilingUtil.isCPUProfiling() || AsyncProfilerHandler.getInstance(project).isProfilingStarted();
    }

    public boolean isStoppedByScript() {
        return this.stoppedByScript;
    }

    public void setStoppedByScript(boolean stoppedByScript) {
        this.stoppedByScript = stoppedByScript;
    }

    public String getReportsPath() {
        return this.reportsPath;
    }

    public void setReportsPath(String reportsPath) {
        this.reportsPath = reportsPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/performancePlugin/profilers/ProfilersController", "isProfilingStarted"));
    }
}

