/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.PhpSpecUtil;
import com.jetbrains.php.phpspec.run.PhpSpecRunConfiguration;
import com.jetbrains.php.phpspec.run.PhpSpecRunConfigurationType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecRunConfigurationProducer
extends RunConfigurationProducer<PhpSpecRunConfiguration> {
    public PhpSpecRunConfigurationProducer() {
        super((ConfigurationType)PhpSpecRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(PhpSpecRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (!PhpSpecSettingsManager.getInstance(configuration.getProject()).isEnabled()) {
            return false;
        }
        Location location = context.getLocation();
        if (!(location instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PsiElement element = PhpSpecRunConfigurationProducer.findTestElement(originalElement);
        if (element == null) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return false;
        }
        PhpTestRunConfigurationSettings settings = (PhpTestRunConfigurationSettings)configuration.getSettings();
        PhpTestRunnerSettings testRunnerSettings = settings.getRunnerSettings();
        if (element instanceof PsiDirectory) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Directory);
            testRunnerSettings.setDirectoryPath(virtualFile.getPresentableUrl());
        } else if (element instanceof PhpClass) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.File);
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        } else if (element instanceof Method) {
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.Method);
            testRunnerSettings.setMethodName(((Method)element).getName());
            testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        } else {
            return false;
        }
        sourceElement.set((Object)element);
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(PhpSpecRunConfiguration configuration, ConfigurationContext context) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement psiElement = PhpSpecRunConfigurationProducer.findTestElement(location.getPsiElement());
        if (psiElement instanceof PsiDirectory) {
            String directoryPath = ((PsiDirectory)psiElement).getVirtualFile().getPath();
            PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)configuration.getSettings()).getRunnerSettings();
            String path = testRunnerSettings.getDirectoryPath();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Directory && path != null && FileUtil.comparePaths((String)directoryPath, (String)FileUtil.toSystemIndependentName((String)path)) == 0;
        }
        if (psiElement instanceof PhpClass) {
            PsiFile psiFile2 = psiElement.getContainingFile();
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                String path = virtualFile2.getPath();
                PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)configuration.getSettings()).getRunnerSettings();
                String filePath = testRunnerSettings.getFilePath();
                return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.File && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0;
            }
        } else if (psiElement instanceof Method && (virtualFile = (psiFile = psiElement.getContainingFile()).getVirtualFile()) != null) {
            String path = virtualFile.getPath();
            PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)configuration.getSettings()).getRunnerSettings();
            String filePath = testRunnerSettings.getFilePath();
            String name = ((Method)psiElement).getName();
            return testRunnerSettings.getScope() == PhpTestRunnerSettings.Scope.Method && filePath != null && FileUtil.comparePaths((String)path, (String)FileUtil.toSystemIndependentName((String)filePath)) == 0 && StringUtil.equals((CharSequence)name, (CharSequence)testRunnerSettings.getMethodName());
        }
        return false;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        PhpClass clazz;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return PhpSpecRunConfigurationProducer.isValidDirectory((PsiDirectory)element) ? element : null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PhpFile && (clazz = (PhpClass)PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)file)).stream().filter(c -> PhpSpecUtil.isSpecTestClass(file.getProject(), c.getFQN())).findAny().orElse(null)) != null) {
            PsiElement method;
            if (!(element instanceof PsiFile) && (method = PhpSpecRunConfigurationProducer.getValidMethod(element)) != null) {
                return method;
            }
            return clazz;
        }
        return null;
    }

    public static boolean isValidDirectory(@NotNull PsiDirectory file) {
        if (file == null) {
            PhpSpecRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        Project project = file.getProject();
        VirtualFile directory = file.getVirtualFile();
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory);
        if (module != null) {
            GlobalSearchScope scope = module.getModuleContentWithDependenciesScope().intersectWith(GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)directory, (boolean)true));
            return FileTypeIndex.getFiles((FileType)PhpFileType.INSTANCE, (GlobalSearchScope)scope).size() > 0;
        }
        return false;
    }

    @Nullable
    public static PsiElement getValidMethod(@NotNull PsiElement element) {
        Method method;
        if (element == null) {
            PhpSpecRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return (method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition)Method.INSTANCEOF)) != null && PhpSpecUtil.isSpecTestMethod(method) ? method : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpspec/run/PhpSpecRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

