/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpSmartFunctionParametersLookupElement;
import com.jetbrains.php.completion.insert.PhpClassConstructorInsertHandler;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionInsertHandler
extends PhpReferenceInsertHandler {
    private static final PhpFunctionInsertHandler INSTANCE = new PhpFunctionInsertHandler();

    public static PhpFunctionInsertHandler getInstance() {
        return INSTANCE;
    }

    protected PhpFunctionInsertHandler() {
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        if (context == null) {
            PhpFunctionInsertHandler.$$$reportNull$$$0(0);
        }
        if (lookupElement == null) {
            PhpFunctionInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        if (context.getCompletionChar() == '(') {
            context.setAddCompletionChar(false);
        }
        if (lookupElement instanceof PhpLookupElement) {
            PsiFile file = context.getFile();
            PsiElement element = file.findElementAt(context.getStartOffset());
            boolean notInUse = PhpUseImpl.getUseList(element) == null;
            PhpNamedElement namedElement = ((PhpLookupElement)lookupElement).getNamedElement();
            if (!(namedElement instanceof Method)) {
                super.handleInsert(context, lookupElement);
            }
            if (notInUse) {
                Function function = this.getFunction(editor, namedElement);
                if (!PhpInsertHandlerUtil.isStringAtCaret(editor, "(")) {
                    if (!this.shouldInsertParens(file, function)) {
                        return;
                    }
                    this.insertParenthesesCodeStyleAware(file, editor, function);
                    if (function != null && PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) == null && function.getParameters().length > 0) {
                        editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                        PhpFunctionInsertHandler.showParameterInfo(editor);
                        if (PhpSmartKeysConfiguration.getInstance().isSmartFunctionParametersCompletion()) {
                            TemplateImpl template = PhpSmartFunctionParametersLookupElement.getTemplate(function);
                            TemplateManager.getInstance((Project)context.getProject()).startTemplate(context.getEditor(), (Template)template);
                        }
                    }
                } else if (PhpInsertHandlerUtil.isStringAtCaret(editor, "()")) {
                    editor.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
                } else {
                    editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                    PhpFunctionInsertHandler.showParameterInfo(editor);
                }
                TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(editor);
            }
        }
    }

    private void insertParenthesesCodeStyleAware(@NotNull PsiFile file, @NotNull Editor editor, @Nullable Function function) {
        if (file == null) {
            PhpFunctionInsertHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PhpFunctionInsertHandler.$$$reportNull$$$0(3);
        }
        boolean space = false;
        if (!(this instanceof PhpClassConstructorInsertHandler)) {
            boolean array;
            String name = function != null ? function.getName() : "";
            String namespaceName = function != null ? function.getNamespaceName() : "";
            boolean global = PhpLangUtil.isFqn(namespaceName) && PhpLangUtil.isGlobalNamespaceFQN(namespaceName);
            boolean bl = array = global && PhpLangUtil.equalsFunctionNames("array", name);
            if (array || !global || !SPECIAL_REFERENCES.contains(name)) {
                CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE);
                space = array ? settings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE : settings.SPACE_BEFORE_METHOD_CALL_PARENTHESES;
            }
        }
        PhpInsertHandlerUtil.insertStringAtCaret(editor, space ? " ()" : "()");
    }

    @Nullable
    protected Function getFunction(Editor editor, PhpNamedElement element) {
        PsiElement function;
        PhpReference reference;
        if (element instanceof Function) {
            return (Function)element;
        }
        if (element instanceof PhpUse && PhpUseImpl.isOfFunction((PhpUse)element) && (reference = ((PhpUse)element).getTargetReference()) != null && (function = reference.resolve()) instanceof Function) {
            return (Function)function;
        }
        return null;
    }

    protected boolean shouldInsertParens(@NotNull PsiFile file, @Nullable Function function) {
        if (file == null) {
            PhpFunctionInsertHandler.$$$reportNull$$$0(4);
        }
        return true;
    }

    public static void showParameterInfo(Editor editor) {
        Project project = editor.getProject();
        assert (project != null);
        AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpFunctionInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insertParenthesesCodeStyleAware";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInsertParens";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

