/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.ComposerConfigListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerJsonConfigService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ComposerJsonConfigService.class);
    private final ComposerDataService myService;
    @NotNull
    private final Project myProject;
    private VirtualFile myConfig;
    private final List<ComposerConfigListener<?>> myClients;
    private final VirtualFileListener myVirtualFileListener;

    public static ComposerJsonConfigService getInstance(Project project) {
        return (ComposerJsonConfigService)ServiceManager.getService((Project)project, ComposerJsonConfigService.class);
    }

    public ComposerJsonConfigService(@NotNull Project project) {
        if (project == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(0);
        }
        this.myClients = Collections.synchronizedList(new ArrayList());
        this.myService = ComposerDataService.getInstance(project);
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        for (ComposerConfigClient client : (ComposerConfigClient[])ComposerConfigClient.EP_NAME.getExtensions()) {
            this.addClient(client);
        }
        this.myVirtualFileListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.fileChanged(event.getFile(), null);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.fileChanged(event.getFile(), event.getFile());
            }

            private void fileChanged(VirtualFile fileToTest, VirtualFile newConfig) {
                if (ComposerJsonConfigService.this.myConfig != null && ComposerJsonConfigService.this.myConfig.equals(fileToTest)) {
                    ComposerJsonConfigService.this.handleChange(newConfig);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerJsonConfigService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myService.addSynchronizationInitListener(() -> this.handleInit());
        this.myService.addConfigListener(new com.jetbrains.php.composer.ComposerConfigListener(){

            @Override
            public void configPathOrLibraryStatusChanged(boolean oldStatus, boolean newStatus) {
                VirtualFile newConfig = ComposerJsonConfigService.this.getCurrentConfigFile();
                if (newConfig == null && ComposerJsonConfigService.this.myConfig == null) {
                    return;
                }
                if (newConfig != null && newConfig.equals(ComposerJsonConfigService.this.myConfig)) {
                    return;
                }
                ComposerJsonConfigService.this.handleChange(newConfig);
            }
        });
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (this.myService.isConfigWellConfigured() && this.myService.getSynchronizationState() == ComposerDataService.SynchronizationState.NOT_INITIALIZED) {
                ComposerSettingSyncConfigClient.initOrSuggestSync(this.myProject);
            }
            this.handleChange(this.getCurrentConfigFile());
        });
    }

    private <T> void addClient(ComposerConfigClient<T> client) {
        ComposerConfigListener<T> listener = new ComposerConfigListener<T>(client);
        this.myClients.add(listener);
    }

    @Nullable
    private VirtualFile getCurrentConfigFile() {
        String path = this.myService.getConfigPath();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private void handleChange(VirtualFile newConfig) {
        if (this.myConfig == null && newConfig != null) {
            LocalFileSystem.getInstance().addVirtualFileListener(this.myVirtualFileListener);
        } else if (this.myConfig != null && newConfig == null) {
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
        }
        this.myConfig = newConfig;
        JsonElement fileElement = ComposerJsonConfigService.getElement(newConfig);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(() -> this.doInform(fileElement), ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.doInform(fileElement);
        }
    }

    private void handleInit() {
        if (this.myConfig == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.doInform(ComposerJsonConfigService.getElement(this.myConfig), true), ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private void doInform(JsonElement fileElement) {
        this.doInform(fileElement, false);
    }

    private void doInform(JsonElement fileElement, boolean initialized) {
        for (ComposerConfigListener<?> client : this.myClients) {
            client.inform(fileElement, this.myProject, initialized);
        }
    }

    @Nullable
    private static JsonElement getElement(VirtualFile newConfig) {
        JsonElement fileElement = null;
        if (newConfig != null) {
            try {
                fileElement = ComposerConfigUtils.parseJson(newConfig);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return fileElement;
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/configData/ComposerJsonConfigService", "<init>"));
    }
}

