/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.lib.ComposerLibraryManager;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageComposerConfigClient
implements ComposerConfigClient<String> {
    private final String myFrameworkPackage;
    private final String myRelativePath;

    protected PackageComposerConfigClient(@NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkPackage == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(1);
        }
        this.myFrameworkPackage = frameworkPackage;
        this.myRelativePath = relativePath;
    }

    @Override
    public String parse(@NotNull Map<String, JsonElement> elements) {
        if (elements == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(2);
        }
        for (JsonElement element : elements.values()) {
            JsonObject object;
            JsonElement require;
            if (element == null || !element.isJsonObject() || (require = (object = element.getAsJsonObject()).get(this.myFrameworkPackage)) == null || !require.isJsonPrimitive()) continue;
            return require.getAsString();
        }
        return null;
    }

    @Override
    public void consume(@Nullable String version, @NotNull Project project) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)version)) {
            return;
        }
        String interpreterId = ComposerDataService.getInstance((Project)project).getComposerExecutionData().interpreterId;
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        this.updateSettings(project, interpreter);
    }

    @Nullable
    protected String findFromComposerVendor(@NotNull Project project) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(4);
        }
        return this.findFromComposerVendor(project, this.myRelativePath);
    }

    @Nullable
    protected String findFromComposerVendor(@NotNull Project project, @NotNull String relativePath) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(6);
        }
        relativePath = StringUtil.trimStart((String)PathUtil.toSystemIndependentName((String)relativePath), (String)"/");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return relativePath;
        }
        VirtualFile vendor = ComposerLibraryManager.getInstance(project).refreshVendorDir(true, null);
        return vendor != null ? vendor.getPath() + "/" + relativePath : null;
    }

    protected void notify(@NotNull Project project, @NotNull String displayName, @Nullable ComposerLogMessageBuilder.Settings settings) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(7);
        }
        if (displayName == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(8);
        }
        String title = PhpBundle.message("framework.composer.packages.were.changed.0.test.config.title", new Object[0]);
        String message = PhpBundle.message("framework.composer.packages.were.changed.0.test.config.popup", displayName);
        ComposerLogService.getInstance(project).report(title + ". " + message, settings, true, null, false);
    }

    @Override
    @NotNull
    public List<String> getPath() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{"require", "require-dev"});
        if (arrayList == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(10);
        }
    }

    public static void updatePackagesSettings(@NotNull Project project) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(11);
        }
        for (ComposerConfigClient client : (ComposerConfigClient[])EP_NAME.getExtensions()) {
            String interpreterId = ComposerDataService.getInstance((Project)project).getComposerExecutionData().interpreterId;
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
            PackageComposerConfigClient packageComposerConfigClient = (PackageComposerConfigClient)ObjectUtils.tryCast((Object)client, PackageComposerConfigClient.class);
            if (packageComposerConfigClient == null) continue;
            packageComposerConfigClient.updateSettings(project, interpreter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/configData/PackageComposerConfigClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/configData/PackageComposerConfigClient";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFromComposerVendor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

