/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerDetectionManager;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.configData.ComposerJsonConfigService;
import com.jetbrains.php.composer.editor.ComposerEditorNotificationPanel;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerLibraryManager
implements ProjectComponent,
ComposerConfigListener,
VirtualFileListener {
    private static final Logger LOG = Logger.getInstance(ComposerLibraryManager.class);
    private static final String COMPOSER_VENDORS_LIBRARY_NAME = PhpBundle.message("framework.composer.vendors.library.name", new Object[0]);
    @NonNls
    private static final String COMPOSER_VENDORS_SUBDIRECTORY_NAME = "composer";
    private final Alarm myNotificationAlarm;
    private final Set<Pair<String, ComposerLogMessageBuilder.Settings>> myNotifications;
    private final Object myNotificationsLock;
    private final Project myProject;
    private VirtualFile myConfig;
    private String myVendorRelativePath;
    private VirtualFile myVendorDir;
    private VirtualFile myBinDir;

    public static ComposerLibraryManager getInstance(Project project) {
        return (ComposerLibraryManager)project.getComponent(ComposerLibraryManager.class);
    }

    private ComposerLibraryManager(@NotNull Project project) {
        if (project == null) {
            ComposerLibraryManager.$$$reportNull$$$0(0);
        }
        this.myNotifications = new TreeSet<Pair<String, ComposerLogMessageBuilder.Settings>>((o1, o2) -> StringUtil.comparePairs((String)((String)Pair.getFirst((Pair)o1)), (String)(o1 == null || o1.second == null ? null : ((ComposerLogMessageBuilder.Settings)((Object)((Object)o1.second))).getId()), (String)((String)Pair.getFirst((Pair)o2)), o2 == null || o2.second == null ? null : ((ComposerLogMessageBuilder.Settings)((Object)((Object)o2.second))).getId(), (boolean)false));
        this.myNotificationsLock = new Object();
        this.myProject = project;
        ComposerDataService service = ComposerDataService.getInstance(project);
        service.addConfigListener(this);
        this.myNotificationAlarm = new Alarm((Disposable)project);
    }

    public void projectOpened() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            Set<VirtualFile> packages = ComposerLibraryManager.readOldLibraries(this.myProject);
            ComposerDataService dataService = ComposerDataService.getInstance(this.myProject);
            this.reloadLibraries(true, packages, dataService.isUpdateLibrary(), dataService.isUpdateLibrary());
            ComposerDetectionManager.offerInitialization(this.myProject);
        });
        ComposerJsonConfigService.getInstance(this.myProject);
        ComposerEditorNotificationPanel.init(this.myProject);
    }

    public void projectClosed() {
        LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this);
    }

    @Nullable
    public VirtualFile refreshVendorDir(boolean asynchronous, @Nullable Runnable postRefresh) {
        if (this.myVendorDir == null && this.myConfig != null && this.myVendorRelativePath != null) {
            VirtualFile vendorDir = this.findVendorDir();
            ComposerUtils.refreshVendorDirectory(vendorDir, asynchronous, postRefresh);
        }
        return this.myVendorDir;
    }

    @Nullable
    public VirtualFile findVendorDirForUpsource() {
        return this.findVendorDir();
    }

    @Nullable
    private VirtualFile findVendorDir() {
        return ComposerUtils.findVendorDir(this.myConfig, this.myVendorRelativePath);
    }

    private void reloadLibraries(boolean force, Set<VirtualFile> oldPackagesToAdd, boolean oldUpdateStatus, boolean newUpdateStatus) {
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile oldConfig = this.myConfig;
        VirtualFile oldVendor = this.myVendorDir;
        VirtualFile oldBin = this.myBinDir;
        this.reloadMainFiles();
        if (oldConfig != null && this.myConfig == null) {
            LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        } else if (oldConfig == null && this.myConfig != null) {
            LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this);
        }
        if (force || ComposerLibraryManager.changed(oldVendor, this.myVendorDir) || ComposerLibraryManager.changed(oldBin, this.myBinDir) || oldUpdateStatus != newUpdateStatus || !oldPackagesToAdd.isEmpty()) {
            this.resetLibrariesAndExcludedPaths(null, oldPackagesToAdd, oldUpdateStatus, newUpdateStatus, oldVendor, this.myVendorDir, oldBin, this.myBinDir);
        }
    }

    private void resetLibrariesAndExcludedPaths(Collection<VirtualFile> deletedFiles, Set<VirtualFile> oldPackagesToAdd, boolean oldUpdateStatus, boolean newUpdateStatus, VirtualFile oldVendorDir, VirtualFile vendorDir, VirtualFile oldBinDir, VirtualFile binDir) {
        if (oldUpdateStatus && !newUpdateStatus) {
            this.removeAllPackagesWithInfo(oldVendorDir, oldBinDir);
        } else if (oldUpdateStatus) {
            this.addOldPackages(oldPackagesToAdd);
            this.changePackages(deletedFiles, oldVendorDir, vendorDir, oldBinDir, binDir, false);
        } else if (newUpdateStatus) {
            this.changePackages(deletedFiles, oldVendorDir, vendorDir, oldBinDir, binDir, true);
        }
    }

    private void addOldPackages(Set<VirtualFile> add) {
        if (add.isEmpty()) {
            return;
        }
        this.changeIncludePaths(add, Collections.emptySet(), null, null);
        ComposerLogService.getInstance(this.myProject).report(PhpBundle.message("framework.composer.packages.were.moved.to.0.php.include.paths.popup", new Object[0]), ComposerLogMessageBuilder.Settings.PHP);
    }

    private void changePackages(Collection<VirtualFile> deletedFiles, VirtualFile oldVendorDir, VirtualFile vendorDir, VirtualFile oldBinDir, VirtualFile binDir, boolean syncTurnedOn) {
        HashSet<VirtualFile> filesToAdd = new HashSet<VirtualFile>();
        HashSet<VirtualFile> filesToRemove = new HashSet<VirtualFile>();
        filesToRemove.addAll(ComposerLibraryManager.getPackages(oldVendorDir, oldBinDir));
        filesToAdd.addAll(ComposerLibraryManager.getPackages(vendorDir, binDir));
        if (deletedFiles != null && !deletedFiles.isEmpty()) {
            List deleted = ContainerUtil.filter(filesToAdd, file -> {
                for (VirtualFile deletedFile : deletedFiles) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)deletedFile, (VirtualFile)file, (boolean)false)) continue;
                    return true;
                }
                return false;
            });
            filesToAdd.removeAll(deleted);
        }
        filesToRemove.removeAll(filesToAdd);
        String includePathsNotificationMessage = PhpBundle.message(syncTurnedOn ? "framework.composer.packages.were.added.0.php.include.paths.popup" : "framework.composer.packages.were.changed.0.php.include.paths.popup", new Object[0]);
        this.changeIncludePaths(filesToAdd, filesToRemove, deletedFiles, includePathsNotificationMessage);
        Module targetModule = null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (this.myConfig != null && vendorDir != null) {
            targetModule = fileIndex.getModuleForFile(vendorDir);
        }
        if (targetModule == null && this.myConfig != null && deletedFiles != null && !deletedFiles.isEmpty()) {
            targetModule = fileIndex.getModuleForFile(deletedFiles.iterator().next());
        }
        if (targetModule == null && this.myConfig != null) {
            targetModule = fileIndex.getModuleForFile(this.myConfig);
        }
        if (targetModule == null) {
            targetModule = ModuleAttachProcessor.getPrimaryModule((Project)this.myProject);
        }
        if (targetModule != null) {
            String notificationMessage = PhpBundle.message(syncTurnedOn ? "framework.composer.packages.were.added.0.excluded.folders.popup" : "framework.composer.packages.were.changed.0.excluded.folders.popup", new Object[0]);
            this.changeExcludedFolders(targetModule, filesToAdd, filesToRemove, deletedFiles, notificationMessage);
        }
    }

    private void removeAllPackagesWithInfo(VirtualFile oldVendorDir, VirtualFile oldBinDir) {
        Collection<VirtualFile> oldPackages = ComposerLibraryManager.getPackages(oldVendorDir, oldBinDir);
        if (oldPackages.isEmpty()) {
            return;
        }
        String notificationMessage = PhpBundle.message("framework.composer.packages.were.removed.0.php.include.paths.popup", new Object[0]);
        this.changeIncludePaths(Collections.emptyList(), oldPackages, null, notificationMessage);
        Module targetModule = null;
        if (this.myConfig != null && oldVendorDir != null) {
            targetModule = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(oldVendorDir);
        }
        if (targetModule == null && ApplicationManager.getApplication().isUnitTestMode()) {
            targetModule = ModuleAttachProcessor.getPrimaryModule((Project)this.myProject);
        }
        if (targetModule != null) {
            this.changeExcludedFolders(targetModule, Collections.emptyList(), oldPackages, Collections.emptySet(), PhpBundle.message("framework.composer.packages.were.removed.0.excluded.folders.popup", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWithPopupAndLinks(String content, ComposerLogMessageBuilder.Settings settings) {
        Object object = this.myNotificationsLock;
        synchronized (object) {
            this.myNotifications.add((Pair<String, ComposerLogMessageBuilder.Settings>)Pair.create((Object)content, (Object)((Object)settings)));
            this.myNotificationAlarm.cancelAllRequests();
            this.myNotificationAlarm.addRequest(() -> this.showNotifications(), 3000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotifications() {
        Object object = this.myNotificationsLock;
        synchronized (object) {
            if (this.myNotifications.isEmpty()) {
                return;
            }
            for (Pair<String, ComposerLogMessageBuilder.Settings> notification2 : this.myNotifications) {
                ComposerLogService.getInstance(this.myProject).report((String)notification2.first, (ComposerLogMessageBuilder.Settings)((Object)notification2.second));
            }
        }
    }

    private void changeIncludePaths(Collection<VirtualFile> filesToAdd, Collection<VirtualFile> filesToRemove, @Nullable Collection<VirtualFile> deletedFilesToRemove, String notificationMessage) {
        IncludePathApplier applier = new IncludePathApplier(filesToAdd, filesToRemove, deletedFilesToRemove, notificationMessage);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && application.isDispatchThread()) {
            applier.run();
        } else {
            application.invokeLater((Runnable)applier, ModalityState.NON_MODAL);
        }
    }

    private static Collection<VirtualFile> getPackages(@Nullable VirtualFile vendorDir, @Nullable VirtualFile binDir) {
        ArrayList<VirtualFile> packages = new ArrayList<VirtualFile>();
        if (vendorDir != null) {
            for (VirtualFile childFile : vendorDir.getChildren()) {
                if (!childFile.isDirectory() || childFile.equals(binDir)) continue;
                if (COMPOSER_VENDORS_SUBDIRECTORY_NAME.equals(childFile.getName())) {
                    packages.add(childFile);
                    continue;
                }
                for (VirtualFile file : childFile.getChildren()) {
                    if (!file.isDirectory()) continue;
                    packages.add(file);
                }
            }
        }
        return packages;
    }

    private void reloadMainFiles() {
        this.myConfig = null;
        String configPath = ComposerDataService.getInstance(this.myProject).getConfigPath();
        if (!StringUtil.isEmpty((String)configPath)) {
            this.myConfig = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        }
        this.reloadComposerDirs();
    }

    private void reloadComposerDirs() {
        this.myVendorRelativePath = null;
        this.myVendorDir = null;
        this.myBinDir = null;
        if (this.myConfig == null || !this.myConfig.exists() || this.myConfig.isDirectory()) {
            return;
        }
        Pair<String, String> vendorAndBinDirs = ComposerConfigUtils.getVendorAndBinDirs(this.myConfig);
        if (vendorAndBinDirs == null) {
            return;
        }
        String vendorRelativePath = (String)vendorAndBinDirs.getFirst();
        if (!StringUtil.isEmpty((String)vendorRelativePath)) {
            this.myVendorRelativePath = vendorRelativePath;
            this.myVendorDir = this.findVendorDir();
        }
        String binDirRelativePath = (String)vendorAndBinDirs.getSecond();
        if (this.myVendorDir != null && binDirRelativePath != null) {
            this.myBinDir = VfsUtil.findRelativeFile((VirtualFile)this.myConfig.getParent(), (String[])new String[]{binDirRelativePath});
        }
    }

    private void changeExcludedFolders(Module module, Collection<VirtualFile> exclude, Collection<VirtualFile> backToProject, Collection<VirtualFile> deletedPackages, String notificationMessage) {
        ExcludedDirectoriesApplier applier = new ExcludedDirectoriesApplier(module, exclude, backToProject, deletedPackages, notificationMessage);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && application.isDispatchThread()) {
            applier.run();
        } else {
            application.invokeLater((Runnable)applier, ModalityState.NON_MODAL);
        }
    }

    public void disposeComponent() {
        this.myNotificationAlarm.cancelAllRequests();
    }

    @Override
    public void configPathOrLibraryStatusChanged(boolean oldStatus, boolean newStatus) {
        this.reloadLibraries(false, Collections.emptySet(), oldStatus, newStatus);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ComposerLibraryManager.$$$reportNull$$$0(1);
        }
        if (this.myConfig != null && this.myConfig.equals(event.getFile())) {
            this.configContentChanged();
        }
    }

    private void configContentChanged() {
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        VirtualFile oldVendorDir = this.myVendorDir;
        VirtualFile oldBinDir = this.myBinDir;
        this.reloadComposerDirs();
        if (ComposerLibraryManager.changed(oldVendorDir, this.myVendorDir) || ComposerLibraryManager.changed(oldBinDir, this.myBinDir)) {
            boolean status = ComposerDataService.getInstance(this.myProject).isUpdateLibrary();
            this.resetLibrariesAndExcludedPaths(null, Collections.emptySet(), status, status, oldVendorDir, this.myVendorDir, oldBinDir, this.myBinDir);
        }
    }

    private static boolean changed(VirtualFile dir, VirtualFile dir1) {
        if (dir == null) {
            return dir1 != null;
        }
        return !dir.equals(dir1);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ComposerLibraryManager.$$$reportNull$$$0(2);
        }
        this.resetLibsIfNeeded(event.getFile(), false);
    }

    private void resetLibsIfNeeded(VirtualFile file, boolean deleted) {
        if (this.myProject == null || this.myProject.isDisposed() || this.myConfig == null) {
            return;
        }
        if (!this.myConfig.isValid()) {
            this.reloadMainFiles();
            if (this.myConfig == null) {
                return;
            }
        }
        if (this.myVendorDir == null) {
            if (!StringUtil.isEmpty((String)this.myVendorRelativePath)) {
                this.myVendorDir = VfsUtil.findRelativeFile((VirtualFile)this.myConfig.getParent(), (String[])new String[]{this.myVendorRelativePath});
            }
            if (this.myVendorDir == null) {
                return;
            }
        }
        if (!file.isDirectory()) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myVendorDir.equals(parent) || this.myVendorDir.equals(parent.getParent()) || this.myVendorDir.equals(file)) {
            if (!this.myVendorDir.exists()) {
                this.myVendorDir = null;
            }
            if (this.myBinDir != null && !this.myBinDir.exists()) {
                this.myBinDir = null;
            }
            List<VirtualFile> deletedFiles = deleted ? Collections.singleton(file) : Collections.emptyList();
            boolean status = ComposerDataService.getInstance(this.myProject).isUpdateLibrary();
            this.resetLibrariesAndExcludedPaths(deletedFiles, Collections.emptySet(), status, status, this.myVendorDir, this.myVendorDir, this.myBinDir, this.myBinDir);
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            ComposerLibraryManager.$$$reportNull$$$0(3);
        }
        this.resetLibsIfNeeded(event.getFile(), true);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            ComposerLibraryManager.$$$reportNull$$$0(4);
        }
    }

    private static Set<VirtualFile> readOldLibraries(@NotNull Project project) {
        if (project == null) {
            ComposerLibraryManager.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> packages = new HashSet<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Library library = LibraryUtil.findLibrary((Module)module, (String)COMPOSER_VENDORS_LIBRARY_NAME);
            if (library == null) continue;
            VirtualFile[] sources = library.getFiles(OrderRootType.SOURCES);
            VirtualFile[] classes = library.getFiles(OrderRootType.CLASSES);
            packages.addAll(Arrays.asList(sources));
            packages.addAll(Arrays.asList(classes));
            PhpAdditionalLibraryManager.deleteLibrary(COMPOSER_VENDORS_LIBRARY_NAME, module);
        }
        return packages;
    }

    public boolean isRootToAdd(VirtualFile file) {
        if (file == null || this.myVendorDir == null) {
            return false;
        }
        VirtualFile parent = file.getParent();
        if (COMPOSER_VENDORS_SUBDIRECTORY_NAME.equals(file.getName()) && this.myVendorDir.equals(parent)) {
            return true;
        }
        return parent != null && this.myVendorDir.equals(parent.getParent());
    }

    public boolean isUpdatingLibrary() {
        return ComposerDataService.getInstance(this.myProject).isUpdateLibrary() && this.myVendorDir != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/lib/ComposerLibraryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCopied";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readOldLibraries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ExcludedDirectoriesApplier
    implements Runnable {
        private final Module myModule;
        private final Collection<VirtualFile> myExclude;
        private final Collection<VirtualFile> myBackToProject;
        private final Collection<VirtualFile> myDeletedFiles;
        private final String myNotificationMessage;

        private ExcludedDirectoriesApplier(Module module, Collection<VirtualFile> exclude, Collection<VirtualFile> project, Collection<VirtualFile> deletedFiles, String message) {
            this.myModule = module;
            this.myExclude = exclude;
            this.myBackToProject = project;
            this.myDeletedFiles = deletedFiles;
            this.myNotificationMessage = message;
        }

        @Override
        public void run() {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            ContentEntry[] contentEntries = model.getContentEntries();
            if (contentEntries.length == 0) {
                model.dispose();
                return;
            }
            boolean changed = false;
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myModule.getProject()).getFileIndex();
            block0: for (VirtualFile file : this.myExclude) {
                if (!this.myModule.equals(index.getModuleForFile(file))) continue;
                String string = file.getUrl();
                String filePath = VfsUtilCore.urlToPath((String)string);
                for (ContentEntry entry : contentEntries) {
                    String rootPath = VfsUtilCore.urlToPath((String)entry.getUrl());
                    if (!FileUtil.isAncestor((String)rootPath, (String)filePath, (boolean)false)) continue;
                    VirtualFile[] excluded = entry.getExcludeFolderFiles();
                    boolean found = false;
                    for (VirtualFile excludedFile : excluded) {
                        if (!excludedFile.equals(file)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    entry.addExcludeFolder(string);
                    changed = true;
                    continue block0;
                }
            }
            for (VirtualFile file : this.myBackToProject) {
                for (ContentEntry entry : contentEntries) {
                    if (!entry.removeExcludeFolder(file.getUrl())) continue;
                    changed = true;
                }
            }
            if (this.myDeletedFiles != null && !this.myDeletedFiles.isEmpty()) {
                for (VirtualFile file : this.myDeletedFiles) {
                    String string = file.getUrl();
                    for (ContentEntry entry : contentEntries) {
                        List excludeFolderUrls = entry.getExcludeFolderUrls();
                        for (String excludeFolderUrl : excludeFolderUrls) {
                            if (!VfsUtilCore.isEqualOrAncestor((String)string, (String)excludeFolderUrl) || !entry.removeExcludeFolder(excludeFolderUrl)) continue;
                            changed = true;
                        }
                    }
                }
            }
            if (changed) {
                ApplicationManager.getApplication().runWriteAction(() -> model.commit());
                if (this.myNotificationMessage != null) {
                    ComposerLibraryManager.this.notifyWithPopupAndLinks(this.myNotificationMessage, ComposerLogMessageBuilder.Settings.DIRECTORIES);
                }
            } else {
                model.dispose();
            }
        }
    }

    private class IncludePathApplier
    implements Runnable {
        private final Collection<VirtualFile> myFilesToAdd;
        private final Collection<VirtualFile> myFilesToRemove;
        @Nullable
        private final Set<VirtualFile> myDeletedFilesToRemove;
        private final String myNotificationMessage;

        private IncludePathApplier(Collection<VirtualFile> filesToAdd, @Nullable Collection<VirtualFile> filesToRemove, Collection<VirtualFile> deletedFilesToRemove, String notificationMessage) {
            this.myFilesToAdd = filesToAdd;
            this.myFilesToRemove = filesToRemove;
            this.myDeletedFilesToRemove = deletedFilesToRemove == null ? Collections.emptySet() : new HashSet<VirtualFile>(deletedFilesToRemove);
            this.myNotificationMessage = notificationMessage;
        }

        @Override
        public void run() {
            if (ComposerLibraryManager.this.myProject.isDisposed()) {
                return;
            }
            PhpIncludePathManager facade = PhpIncludePathManager.getInstance(ComposerLibraryManager.this.myProject);
            List<String> paths = facade.getIncludePath();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ArrayList<String> newPaths = new ArrayList<String>();
            boolean changed = false;
            block0: for (String path : paths) {
                VirtualFile file = fileSystem.findFileByPath(path);
                if (file != null && this.myFilesToRemove.contains(file)) {
                    changed = true;
                    continue;
                }
                if (file == null && this.myDeletedFilesToRemove != null && !this.myDeletedFilesToRemove.isEmpty()) {
                    for (VirtualFile deletedFileToRemove : this.myDeletedFilesToRemove) {
                        if (!VfsUtilCore.isEqualOrAncestor((String)deletedFileToRemove.getPath(), (String)path)) continue;
                        changed = true;
                        continue block0;
                    }
                }
                if (file != null) {
                    this.myFilesToAdd.remove(file);
                }
                newPaths.add(path);
            }
            if (!this.myFilesToAdd.isEmpty()) {
                changed = true;
                for (VirtualFile file : this.myFilesToAdd) {
                    newPaths.add(file.getPath());
                }
            }
            if (changed) {
                LOG.warn("Updated composer include paths. Add " + this.myFilesToAdd + ",\nremove " + this.myFilesToRemove + ",\ndeleted files " + this.myDeletedFilesToRemove);
                facade.setIncludePath(newPaths);
                if (this.myNotificationMessage != null) {
                    ComposerLibraryManager.this.notifyWithPopupAndLinks(this.myNotificationMessage, ComposerLogMessageBuilder.Settings.PHP);
                }
            }
        }
    }
}

