/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="php_custom_format_function")
public class PhpCustomFormatFunction {
    @NotNull
    private String namespaceName;
    @Nullable
    private String className;
    @NotNull
    private String functionName;
    private int formatParameterIndex;

    public PhpCustomFormatFunction() {
        this("", null, "", 0);
    }

    public PhpCustomFormatFunction(@NotNull String namespaceName, @Nullable String className, @NotNull String functionName, int formatParameterIndex) {
        if (namespaceName == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(1);
        }
        this.functionName = functionName;
        this.className = className;
        this.namespaceName = namespaceName;
        this.formatParameterIndex = formatParameterIndex;
    }

    public PhpCustomFormatFunction(@NotNull String functionFqn, int formatParameterIndex) {
        if (functionFqn == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(2);
        }
        this(PhpLangUtil.getParentNamespaceFQN(functionFqn), null, PhpLangUtil.toShortName(functionFqn), formatParameterIndex);
    }

    public PhpCustomFormatFunction(Function f, int formatParameterIndex) {
        this(f.getNamespaceName(), PhpCustomFormatFunction.getClassName(f), f.getName(), formatParameterIndex);
    }

    public String getFunctionFqn() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.namespaceName);
        if (!StringUtil.endsWith((CharSequence)sb, (CharSequence)"\\")) {
            sb.append("\\");
        }
        if (this.className != null) {
            sb.append(this.className);
            sb.append(".");
        }
        sb.append(this.functionName);
        return sb.toString();
    }

    @Nullable
    private static String getClassName(Function f) {
        PhpClass containingClass;
        if (f instanceof Method && (containingClass = ((Method)f).getContainingClass()) != null) {
            return containingClass.getName();
        }
        return null;
    }

    @Attribute(value="function_name")
    @NotNull
    public String getFunctionName() {
        String string = this.functionName;
        if (string == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Attribute(value="format_parameter_index")
    public int getFormatParameterIndex() {
        return this.formatParameterIndex;
    }

    @Attribute(value="class_name")
    @Nullable
    public String getClassName() {
        return this.className;
    }

    @Attribute(value="namespace_name")
    @NotNull
    public String getNamespaceName() {
        String string = this.namespaceName;
        if (string == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isMethod() {
        return this.className != null;
    }

    public void setFunctionName(@NotNull String functionFqn) {
        if (functionFqn == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(5);
        }
        this.functionName = functionFqn;
    }

    public void setFormatParameterIndex(int formatParameterIndex) {
        this.formatParameterIndex = formatParameterIndex;
    }

    public void setNamespaceName(@NotNull String namespaceName) {
        if (namespaceName == null) {
            PhpCustomFormatFunction.$$$reportNull$$$0(6);
        }
        this.namespaceName = namespaceName;
    }

    public void setClassName(@Nullable String className) {
        this.className = className;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionFqn";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpCustomFormatFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpCustomFormatFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFunctionName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNamespaceName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

