/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"detectAndApply", "", "project", "Lcom/intellij/openapi/project/Project;", "configurable", "Lcom/jetbrains/php/config/PhpProjectConfigurableForm;", "phpInfo", "Lcom/jetbrains/php/config/phpInfo/PhpInfo;", "balloonAnchor", "Ljava/awt/Component;", "getConfiguredExtensions", "", "", "", "getLoadedExtensions", "showBalloon", "message", "anchor", "intellij.php.impl"})
public final class PhpExtensionsDetectorKt {
    public static final void detectAndApply(@NotNull Project project, @NotNull PhpProjectConfigurableForm configurable, @NotNull PhpInfo phpInfo, @NotNull Component balloonAnchor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurable, (String)"configurable");
        Intrinsics.checkParameterIsNotNull((Object)phpInfo, (String)"phpInfo");
        Intrinsics.checkParameterIsNotNull((Object)balloonAnchor, (String)"balloonAnchor");
        Map<String, Boolean> loadedExtensions = PhpExtensionsDetectorKt.getLoadedExtensions(phpInfo);
        Map<String, Boolean> configuredExtensions = PhpExtensionsDetectorKt.getConfiguredExtensions(project);
        Map modifications = new LinkedHashMap();
        Map map = ContainerUtil.diff(loadedExtensions, configuredExtensions);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"ContainerUtil.diff(loade\u2026ns, configuredExtensions)");
        Map map2 = map;
        for (Map.Entry object2 : map2.entrySet()) {
            String string;
            Boolean bl;
            Object object = object2;
            String key = (String)object.getKey();
            object = object2;
            Couple couple = (Couple)object.getValue();
            if (couple.first != null && couple.second != null) {
                object = modifications;
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                bl = true;
                object.put(string, bl);
            }
            if (couple.first != null) continue;
            Object object3 = couple.second;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"couple.second");
            if (!((Boolean)object3).booleanValue()) continue;
            object = modifications;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
            bl = false;
            object.put(string, bl);
        }
        Map map3 = modifications;
        if (!map3.isEmpty()) {
            int n;
            configurable.setExtensions(MapsKt.plus(configuredExtensions, (Map)modifications));
            Map $receiver$iv = modifications;
            if ($receiver$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Map map4 = $receiver$iv;
                for (Map.Entry element$iv : map4.entrySet()) {
                    Map.Entry it = element$iv;
                    if (!((Boolean)it.getValue()).booleanValue()) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            int n2 = n;
            int disabled = modifications.size() - n2;
            PhpExtensionsDetectorKt.showBalloon("Enabled " + n2 + " and disabled " + disabled + " extensions", balloonAnchor, project);
        } else {
            PhpExtensionsDetectorKt.showBalloon("Configuration remains unchanged", balloonAnchor, project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Boolean> getLoadedExtensions(PhpInfo phpInfo) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Map<String, PhpProjectConfigurableForm.ExtensionCategory> map = PhpProjectConfigurableForm.getExtensionToCategory();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"PhpProjectConfigurableFo\u2026.getExtensionToCategory()");
        Map<String, PhpProjectConfigurableForm.ExtensionCategory> extensionToCategory = map;
        Set<String> set = phpInfo.getLoadedExtensions();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"phpInfo.loadedExtensions");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            String extension = (String)element$iv$iv;
            if (!(PhpProjectConfigurableForm.ExtensionCategory.CORE != extensionToCategory.get(extension))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv2;
            String extension = (String)element$iv$iv;
            Pair pair = new Pair((Object)extension, (Object)true);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Boolean> getConfiguredExtensions(Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv$iv2;
        Map<String, PhpProjectConfigurableForm.ExtensionCategory> map = PhpProjectConfigurableForm.getExtensionToCategory();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"PhpProjectConfigurableFo\u2026.getExtensionToCategory()");
        Map<String, PhpProjectConfigurableForm.ExtensionCategory> extensionToCategory = map;
        PhpRuntimeConfiguration phpRuntimeConfiguration = PhpRuntimeConfiguration.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)phpRuntimeConfiguration, (String)"PhpRuntimeConfiguration.getInstance(project)");
        Map<String, Boolean> map2 = phpRuntimeConfiguration.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"PhpRuntimeConfiguration.\u2026tance(project).extensions");
        Map<String, Boolean> extensions = map2;
        Set<VirtualFile> set = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"PhpRuntimeLibraryRootsPr\u2026sBeforeFiltering(project)");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v4 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"file");
            String string = v4.getName();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            String extension = (String)element$iv$iv;
            if (!(PhpProjectConfigurableForm.ExtensionCategory.CORE != extensionToCategory.get(extension))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Pair pair;
            Map map3 = destination$iv$iv2;
            String extension = (String)element$iv$iv;
            Map<String, Boolean> map4 = extensions;
            String string = extension;
            Pair pair2 = pair;
            Pair pair3 = pair;
            Boolean bl = map4.get(extension);
            if (bl == null) {
                bl = true;
            }
            Boolean bl2 = bl;
            pair2((Object)string, (Object)bl2);
            Pair pair4 = pair3;
            map3.put(pair4.getFirst(), pair4.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final void showBalloon(String message, Component anchor, Project project) {
        MessageType type = MessageType.INFO;
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        MessageType messageType = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"type");
        BalloonBuilder balloonBuilder = jBPopupFactory.createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), type.getPopupBackground(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)balloonBuilder, (String)"JBPopupFactory.getInstan\u2026pe.popupBackground, null)");
        BalloonBuilder balloonBuilder2 = balloonBuilder;
        balloonBuilder2.setFadeoutTime(3000L);
        Balloon balloon = balloonBuilder2.createBalloon();
        Intrinsics.checkExpressionValueIsNotNull((Object)balloon, (String)"balloonBuilder.createBalloon()");
        Balloon balloon2 = balloon;
        RelativePoint point = new RelativePoint(anchor, new Point(0, 0));
        Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)balloon2));
        balloon2.show(point, Balloon.Position.above);
    }
}

