/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPathMappingsConverter {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.config.servers.PhpPathMappingsConverter");

    @NotNull
    public static List<PathMappingSettings.PathMapping> getMappings(@NotNull Project project, @NotNull WebServerConfig webConfig, @NotNull String pathToRoot) {
        String root;
        if (project == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(0);
        }
        if (webConfig == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(1);
        }
        if (pathToRoot == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(2);
        }
        FileTransferConfig transferConfig = webConfig.getFileTransferConfig();
        String string = root = StringUtil.isEmpty((String)pathToRoot) && transferConfig.getAccessType() == AccessType.MOUNT ? webConfig.getRootPath().path : transferConfig.getRootFolder();
        String fullPathToRoot = StringUtil.isEmpty((String)pathToRoot) ? root.trim() : (StringUtil.isEmpty((String)root) ? pathToRoot.trim() : DeploymentPathUtils.join((String)pathToRoot.trim(), (String)root.trim(), (char)'/'));
        if (fullPathToRoot.endsWith("/") || fullPathToRoot.endsWith("\\")) {
            fullPathToRoot = fullPathToRoot.substring(0, fullPathToRoot.length() - 1);
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        ArrayList<PathMappingSettings.PathMapping> pathMappings = new ArrayList<PathMappingSettings.PathMapping>(mappings.size());
        for (DeploymentPathMapping mapping : mappings) {
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            String fullRemotePath = DeploymentPathUtils.join((String)fullPathToRoot, (String)mapping.getDeployPath(), (char)'/');
            pathMappings.add(new PathMappingSettings.PathMapping(mapping.getLocalPath(), fullRemotePath));
        }
        ArrayList<PathMappingSettings.PathMapping> arrayList = pathMappings;
        if (arrayList == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile findLocalFile(@NotNull WebServerConfig.RemotePath path, @NotNull WebServerConfig server, @NotNull PublishConfig publishConfig) {
        String localPath;
        if (path == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(4);
        }
        if (server == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(5);
        }
        if (publishConfig == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(6);
        }
        return StringUtil.isEmpty((String)(localPath = PhpPathMappingsConverter.findLocalPath(path, server, publishConfig))) ? null : LocalFileSystem.getInstance().findFileByPath(localPath);
    }

    @Nullable
    public static String findLocalPath(@NotNull WebServerConfig.RemotePath path, @NotNull WebServerConfig server, @NotNull PublishConfig publishConfig) {
        String root;
        if (path == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(7);
        }
        if (server == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(8);
        }
        if (publishConfig == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)(root = server.getFileTransferConfig().getRootFolder()))) {
            WebServerConfig.RemotePath relative;
            DeploymentPathMapping mapping;
            boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
            String relativePath = PhpPathMappingsConverter.getPathRemainder(path.path, root, isProtocolBased);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Server: " + server.getName() + " root: " + root + ", full path: " + path.path + ", relative: " + relativePath);
            }
            if (StringUtil.isNotEmpty((String)relativePath) && (mapping = (DeploymentPathMapping)publishConfig.getNearestMappingDeploy2Local(relative = new WebServerConfig.RemotePath(relativePath), false, (Mappable)server).getFirst()) != null) {
                String remainder = DeploymentPathMapping.getPathRemainderForRemotePath((WebServerConfig.RemotePath)relative, (Mappable)server, (String)mapping.getDeployPath());
                if (StringUtil.isEmpty((String)remainder)) {
                    LOG.warn("Can not convert remote path '" + path.path + "' by '" + server.getName() + "' deployment server");
                    return null;
                }
                return mapping.mapToLocalPath(relative, (Mappable)server);
            }
        }
        return null;
    }

    @Nullable
    public static String getPathRemainder(@NotNull String remotePath, @NotNull String pathToRoot, boolean shouldBeRelative) {
        if (remotePath == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(10);
        }
        if (pathToRoot == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(11);
        }
        if (PhpPathMappingsConverter.isRelative(remotePath)) {
            pathToRoot = PhpPathMappingsConverter.ensureRelative(pathToRoot);
        }
        String relativePath = DeploymentPathUtils.getPathRemainder((String)pathToRoot, (String)remotePath, (boolean)true);
        return shouldBeRelative && StringUtil.isNotEmpty((String)relativePath) ? PhpPathMappingsConverter.ensureRelative(relativePath) : relativePath;
    }

    @NotNull
    private static String ensureRelative(@NotNull String path) {
        if (path == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(12);
        }
        String string = PhpPathMappingsConverter.isRelative(path) ? path : "/" + path;
        if (string == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isRelative(@NotNull String path) {
        if (path == null) {
            PhpPathMappingsConverter.$$$reportNull$$$0(14);
        }
        return path.startsWith("/") || path.startsWith("\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webConfig";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToRoot";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpPathMappingsConverter";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpPathMappingsConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureRelative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLocalPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathRemainder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureRelative";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRelative";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

