/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.parser.tags;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Namespace;

public class PhpDocTagParser
implements PhpDocElementTypes {
    public static final TokenSet TYPE_SEP = TokenSet.create((IElementType[])new IElementType[]{DOC_PIPE, DOC_AMPERSAND});

    public void parse(PhpPsiBuilder builder, boolean inside) {
        PsiBuilder.Marker tag = builder.mark();
        builder.match(DOC_TAG_NAME);
        this.parseContents(builder);
        if (!inside) {
            PhpDocTagParser.parseValue(builder);
        }
        tag.done(this.getElementType());
    }

    public IElementType getElementType() {
        return phpDocTag;
    }

    protected boolean parseContents(PhpPsiBuilder builder) {
        PsiBuilder.Marker content = builder.mark();
        if (builder.compareAndEat(DOC_LPAREN)) {
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_COMMENT_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.eof())) {
                if (builder.compare(DOC_TAG_NAME)) {
                    this.parse(builder, true);
                    continue;
                }
                if (builder.compare(DOC_STRING)) {
                    PsiBuilder.Marker mark = builder.mark();
                    builder.match(DOC_STRING);
                    mark.done((IElementType)phpDocString);
                    continue;
                }
                builder.advanceLexer();
            }
            builder.compareAndEat(DOC_RPAREN);
            content.done((IElementType)phpDocAttributeList);
        } else {
            content.drop();
        }
        return true;
    }

    public static boolean parseTypes(PhpPsiBuilder builder) {
        boolean atLeastOneTypeParsed = false;
        while (builder.compare(DOC_IDENTIFIER) || builder.compare(DOC_NAMESPACE) || builder.compare(DOC_VARIABLE) && "$this".equals(builder.getTokenText()) || builder.compare(DOC_HASH) || builder.compare(DOC_LAB)) {
            PsiBuilder.Marker type = builder.mark();
            builder.compareAndEat(DOC_HASH);
            Namespace.parseReference(builder);
            if (!builder.compareAndEat(DOC_IDENTIFIER) && "$this".equals(builder.getTokenText())) {
                builder.advanceLexer();
            }
            if (builder.rawLookup(0) != DOC_WHITESPACE && builder.compare(DOC_LAB)) {
                PsiBuilder.Marker param = builder.mark();
                builder.advanceLexer();
                while (PhpDocTagParser.parseTypes(builder) && builder.compareAndEat(DOC_COMMA)) {
                }
                builder.compareAndEat(DOC_RAB);
                param.done((IElementType)phpDocAttributeList);
            }
            PsiBuilder.Marker array = builder.mark();
            while (builder.compareAndEat(DOC_LBRACKET) && builder.compareAndEat(DOC_RBRACKET)) {
                array.drop();
                array = builder.mark();
            }
            array.rollbackTo();
            atLeastOneTypeParsed = true;
            type.done((IElementType)phpDocType);
            if (!(builder.compare(DOC_LPAREN) | !builder.compareAndEat(TYPE_SEP))) continue;
            break;
        }
        return atLeastOneTypeParsed;
    }

    protected static boolean parseVar(PhpPsiBuilder builder) {
        PsiBuilder.Marker tag = builder.mark();
        builder.compareAndEat(DOC_AMPERSAND);
        if (builder.compare(DOC_TEXT) && "...".equals(builder.getTokenText())) {
            builder.advanceLexer();
        }
        if (builder.compareAndEat(DOC_VARIABLE)) {
            if (builder.compare(DOC_UNLIMITED)) {
                builder.advanceLexer();
            }
            tag.done((IElementType)phpDocVariable);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    protected static boolean parseId(PhpPsiBuilder builder) {
        PsiBuilder.Marker tag = builder.mark();
        if (builder.compareAndEat(DOC_IDENTIFIER) && !builder.compare(DOC_NAMESPACE) && !builder.compare(DOC_PIPE)) {
            tag.done((IElementType)phpDocVariable);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    protected static boolean parseProperty(PhpPsiBuilder builder) {
        if (builder.compare(DOC_LPAREN)) {
            PsiBuilder.Marker paren = builder.mark();
            builder.advanceLexer();
            while (!(builder.compare(DOC_RPAREN) || builder.compare(DOC_LEADING_ASTERISK) || builder.compare(DOC_COMMENT_END) || builder.compare(DOC_VARIABLE) || builder.eof())) {
                builder.advanceLexer();
            }
            if (builder.compare(DOC_RPAREN)) {
                builder.advanceLexer();
                paren.drop();
            } else {
                paren.rollbackTo();
            }
        }
        PsiBuilder.Marker tag = builder.mark();
        if ((builder.compareAndEat(DOC_VARIABLE) || builder.compareAndEat(DOC_IDENTIFIER)) && !builder.compare(DOC_NAMESPACE) && !builder.compare(DOC_PIPE)) {
            tag.done((IElementType)phpDocProperty);
            return true;
        }
        tag.rollbackTo();
        return false;
    }

    protected static void parseValue(PhpPsiBuilder builder) {
        PsiBuilder.Marker value = builder.mark();
        while (!(builder.compare(DOC_TAG_VALUE_END) || builder.compareAndEat(DOC_RBRACE) || builder.eof())) {
            builder.advanceLexer();
        }
        value.done((IElementType)phpDocTagValue);
    }
}

