/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpIncludeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIncludeInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpInclude(Include include) {
                if (include.getStaticElement() == null || include.getError() != null) {
                    String m = "Dynamic include expression '#ref' is not analysed.";
                    if (isOnTheFly && include.getError() != null) {
                        m = m + " " + include.getError();
                    }
                    holder.registerProblem((PsiElement)include, m, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    return;
                }
                PsiReference[] refs = include.getReferences();
                int refsLength = refs.length;
                for (int i = 0; i < refsLength; ++i) {
                    PsiReference ref = refs[i];
                    if (!(ref instanceof FileReference) || ref.resolve() != null) continue;
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray;
                        PsiDirectory dir;
                        try {
                            PsiElement target;
                            dir = i > 0 ? ((target = refs[i - 1].resolve()) instanceof PsiDirectory ? (PsiDirectory)target : null) : include.getContainingFile().getParent();
                        }
                        catch (PsiInvalidElementAccessException e) {
                            throw new RuntimeException("Error while inspecting include reference: '" + include.getText() + "' at " + include.getContainingFile().getParent().getText(), e);
                        }
                        PsiElement psiElement = ref.getElement();
                        TextRange textRange = ref.getRangeInElement();
                        String string = "Path '" + include.getFileName() + "' not found";
                        if (dir != null) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = new CreateFileFix(i < refs.length - 1, ref.getCanonicalText(), dir);
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        holder.registerProblem(psiElement, textRange, string, localQuickFixArray);
                    } else {
                        holder.registerProblem(include.getFirstChild(), "Can't resolve target of expression '" + include.getFileName() + "'", new LocalQuickFix[0]);
                    }
                    return;
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpIncludeInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

