/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddPropertyQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedFieldInspection
extends PhpUndefinedMemberInspection {
    private static final String UNDEFINED_FIELD_REF = "Field '#ref' not found";
    public static final String ADD_PROPERTY_FIX_NAME = "Add @property";
    private static final PhpAddPropertyQuickFix ADD_PROPERTY_FIX = new PhpAddPropertyQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpAddFieldDeclarationQuickFix.INSTANCE, ADD_PROPERTY_FIX};
    private static final PhpType STD_CLASS = new PhpType().add("\\stdClass");
    private static final PhpType ARRAY_OBJECT = new PhpType().add("\\ArrayObject");
    private static final String PROBLEM_1 = PhpBundle.message("inspection.undefined.field.problem1", new Object[0]);
    private static final String PROBLEM_2 = PhpBundle.message("inspection.undefined.field.problem2", new Object[0]);
    public boolean NOTIFY_ACCESS_VIA_MAGIC_METHOD = true;
    public boolean NOTIFY_DYNAMIC_DECLARATION = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (PhpUndefinedFieldInspection.this.isNotifyDynamicDeclaration()) {
                    Field[] fields;
                    for (Field field : fields = clazz.getOwnFields()) {
                        PsiElement psi;
                        if (!(field instanceof PhpClassImpl.MyRenamableFakePsiElement) || !((psi = field.getNavigationElement()) instanceof FieldReference) || ((FieldReference)psi).resolve() != field) continue;
                        LocalQuickFix[] fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(clazz.getProject(), psi) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                        ASTNode node = ((FieldReference)psi).getNameNode();
                        if (node == null || node.getPsi().getContainingFile() != holder.getFile()) continue;
                        holder.registerProblem(node.getPsi(), PROBLEM_2, ProblemHighlightType.WEAK_WARNING, fixes);
                    }
                }
            }

            public void visitPhpFieldReference(FieldReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || this.isDynamicFieldReference(nameNode)) {
                    return;
                }
                Project project = holder.getProject();
                PhpExpression classReference = reference.getClassReference();
                PsiElement psi = nameNode.getPsi();
                if (MemberReferenceImpl.getDepth(classReference) == 100) {
                    holder.registerProblem(psi, "Call chain is too long to analyse, please break into fragments of up to 100 calls", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (classReference instanceof PhpReference && ((PhpReference)classReference).multiResolve(false).length > 0) {
                    PhpType type = classReference.getType().global(project);
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    if (STD_CLASS.isConvertibleFrom(type, index)) {
                        return;
                    }
                    if (ARRAY_OBJECT.isConvertibleFrom(type, index)) {
                        return;
                    }
                    if (PhpType.isSubType((PhpType)PhpType.MIXED, (PhpType)type) || PhpType.isSubType((PhpType)PhpType.OBJECT, (PhpType)type)) {
                        return;
                    }
                    if (reference.multiResolve(false).length == 0) {
                        LocalQuickFix[] fixes;
                        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)reference, PhpAccessFieldByVariableInstruction.class);
                        if (instruction != null) {
                            if (instruction.getAccess().isLightRead()) {
                                return;
                            }
                            Ref canBeDefined = new Ref((Object)false);
                            Ref canBeUndefined = new Ref((Object)false);
                            MyReachingDefinitionDFAnalyzer analyzer = new MyReachingDefinitionDFAnalyzer(instruction);
                            PhpDFAUtil.performReachingDefinition((PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, analyzer);
                            if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
                                return;
                            }
                        }
                        if (reference.getReferenceType() == PhpModifier.State.DYNAMIC) {
                            if (PhpCodeInsightUtil.hasMagicMethod(type, index, reference.isWriteAccess() ? "__set" : "__get")) {
                                LocalQuickFix[] localQuickFixArray = fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                                if (PhpUndefinedFieldInspection.this.isNotifyAccessViaMagicMethod()) {
                                    holder.registerProblem(psi, PROBLEM_1, ProblemHighlightType.WEAK_WARNING, fixes);
                                }
                                return;
                            }
                            PhpAccessInstruction.Access access = PhpCodeInsightUtil.getAccess((PhpPsiElement)reference);
                            if (access.isWrite() && !access.isRead()) {
                                if (PhpUndefinedFieldInspection.this.isNotifyDynamicDeclaration()) {
                                    LocalQuickFix[] fixes2;
                                    LocalQuickFix[] localQuickFixArray = fixes2 = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                                    if (psi.getContainingFile() == holder.getFile()) {
                                        holder.registerProblem(psi, PROBLEM_2, ProblemHighlightType.WEAK_WARNING, fixes2);
                                    }
                                }
                                return;
                            }
                        }
                        fixes = PhpUndefinedFieldInspection.isClassQuickFixApplicable(project, psi) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                        String template = isOnTheFly ? "Field '#ref' not found in " + type.toStringRelativized(reference.getNamespaceName()) : PhpUndefinedFieldInspection.UNDEFINED_FIELD_REF;
                        holder.registerProblem(psi, template, fixes);
                    }
                }
            }

            private boolean isDynamicFieldReference(@NotNull ASTNode nameNode) {
                if (nameNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpPsiUtil.isOfType(nameNode, PhpStubElementTypes.VARIABLE)) {
                    PsiElement prevSibling = nameNode.getPsi().getPrevSibling();
                    if (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                        PsiElement child = PhpPsiUtil.getChildOfType(nameNode.getPsi(), PhpStubElementTypes.VARIABLE);
                        return child != null;
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameNode", "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$1", "isDynamicFieldReference"));
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedFieldInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private boolean isNotifyAccessViaMagicMethod() {
        return this.NOTIFY_ACCESS_VIA_MAGIC_METHOD;
    }

    private boolean isNotifyDynamicDeclaration() {
        return this.NOTIFY_DYNAMIC_DECLARATION;
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.NOTIFY_ACCESS_VIA_MAGIC_METHOD = false;
        this.NOTIFY_DYNAMIC_DECLARATION = false;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static boolean isClassQuickFixApplicable(Project project, PsiElement element) {
        MemberReference reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)element, MemberReference.class, (boolean)false);
        if (reference == null) {
            return false;
        }
        PhpClass klass = PhpQuickFixBase.resolveClass(reference, true);
        if (klass == null) {
            return false;
        }
        return ModuleUtil.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReachingDefinitionDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        @NotNull
        private final PhpAccessFieldByVariableInstruction myInstruction;

        private MyReachingDefinitionDFAnalyzer(@NotNull PhpAccessFieldByVariableInstruction instruction) {
            if (instruction == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(0);
            }
            this.myInstruction = instruction;
        }

        @Override
        @NotNull
        protected PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof PhpIsset) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                for (PhpExpression expression : ((PhpIsset)condition).getVariables()) {
                    if (!PhpCodeInsightUtil.isSameElementFieldReference((PsiElement)expression, this.myInstruction.getVariableName(), this.myInstruction.getFieldName())) continue;
                    dfaResult.setDefined(true);
                    break;
                }
                PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                if (result2 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result2;
            }
            if (condition instanceof PhpEmpty) {
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                if (!result) {
                    for (PhpExpression expression : ((PhpEmpty)condition).getVariables()) {
                        if (!PhpCodeInsightUtil.isSameElementFieldReference((PsiElement)expression, this.myInstruction.getVariableName(), this.myInstruction.getFieldName())) continue;
                        dfaResult.setDefined(true);
                        break;
                    }
                }
                PhpReachingDefinitionDFAnalyzer.Result result3 = dfaResult;
                if (result3 == null) {
                    MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(2);
                }
                return result3;
            }
            PhpReachingDefinitionDFAnalyzer.Result result4 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result4 == null) {
                MyReachingDefinitionDFAnalyzer.$$$reportNull$$$0(3);
            }
            return result4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFieldInspection$MyReachingDefinitionDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JBCheckBox myNotifyAccessMagicCheckBox;
        private JBCheckBox myNotifyDynamicDeclarationCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myNotifyAccessMagicCheckBox.setSelected(PhpUndefinedFieldInspection.this.NOTIFY_ACCESS_VIA_MAGIC_METHOD);
            this.myNotifyAccessMagicCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUndefinedFieldInspection.this.NOTIFY_ACCESS_VIA_MAGIC_METHOD = OptionsPanel.this.myNotifyAccessMagicCheckBox.isSelected();
                }
            });
            this.myNotifyDynamicDeclarationCheckBox.setSelected(PhpUndefinedFieldInspection.this.NOTIFY_DYNAMIC_DECLARATION);
            this.myNotifyDynamicDeclarationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhpUndefinedFieldInspection.this.NOTIFY_DYNAMIC_DECLARATION = OptionsPanel.this.myNotifyDynamicDeclarationCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myNotifyAccessMagicCheckBox = jBCheckBox2 = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.field.notify.access.magic.method"));
            jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNotifyDynamicDeclarationCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.undefined.field.notify.dynamic.declaration"));
            jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

