/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportFunctionQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpUndefinedFunctionInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpImportFunctionQuickFix.INSTANCE};
    private static final String PROBLEM_1 = PhpBundle.message("inspection.undefined.function.problem1", new Object[0]);
    private static final String PROBLEM_2 = PhpBundle.message("inspection.undefined.function.problem2", new Object[0]);
    public static final String FUNCTION_EXISTS = "function_exists";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpSimpleFunctionDefinedDFAnalyzer("function_exists");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                String name = reference.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
                if (results.length == 0) {
                    PhpCallInstruction instruction = PhpControlFlowUtil.getCallInstruction(reference);
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    if (instruction != null) {
                        PhpDFAUtil.performReachingDefinitions((PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, name, DF_ANALYZER);
                    }
                    if (!((Boolean)canBeDefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PROBLEM_1, FIXES);
                    } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                        holder.registerProblem(nameNode.getPsi(), PROBLEM_2, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

