/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.assignment.PhpReplaceableAssignmentCondition;
import com.jetbrains.php.lang.inspections.quickfix.assignment.PhpReplaceAssignmentWithPrefixExpressionQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.assignment.PhpReplaceOperatorAssignmentWithPrefixExpressionQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpAssignmentReplaceableWithPrefixExpressionInspection
extends PhpInspection {
    private static final Condition<SelfAssignmentExpression> REPLACEABLE_OPERATOR_ASSIGNMENT_CONDITION;
    private static final Condition<AssignmentExpression> REPLACEABLE_ASSIGNMENT_CONDITION;

    private static boolean isLiteralIntOne(PsiElement element) {
        if (!(element instanceof PhpExpression)) {
            return false;
        }
        PhpExpression expression = (PhpExpression)element;
        return expression.getType().equals((Object)PhpType.INT) && "1".equals(expression.getText());
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAssignmentReplaceableWithPrefixExpressionInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression assignment) {
                if (REPLACEABLE_OPERATOR_ASSIGNMENT_CONDITION.value((Object)assignment)) {
                    PhpReplaceOperatorAssignmentWithPrefixExpressionQuickFix fix = new PhpReplaceOperatorAssignmentWithPrefixExpressionQuickFix(assignment);
                    String replacementExpression = fix.getReplacementExpressionString();
                    String message = PhpBundle.message("inspection.assignment.replaceable.with", replacementExpression);
                    holder.registerProblem((PsiElement)assignment, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignment) {
                if (REPLACEABLE_ASSIGNMENT_CONDITION.value((Object)assignment)) {
                    PhpReplaceAssignmentWithPrefixExpressionQuickFix fix = new PhpReplaceAssignmentWithPrefixExpressionQuickFix(assignment);
                    String replacementExpression = fix.getReplacementExpressionString();
                    String message = PhpBundle.message("inspection.assignment.replaceable.with", replacementExpression);
                    holder.registerProblem((PsiElement)assignment, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{fix});
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpAssignmentReplaceableWithPrefixExpressionInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    static {
        TokenSet replaceableOperatorTypes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS_ASGN, PhpTokenTypes.opMINUS_ASGN});
        REPLACEABLE_OPERATOR_ASSIGNMENT_CONDITION = assignment -> {
            IElementType operatorType = assignment.getOperationType();
            if (!replaceableOperatorTypes.contains(operatorType)) {
                return false;
            }
            PhpPsiElement value = assignment.getValue();
            return PhpAssignmentReplaceableWithPrefixExpressionInspection.isLiteralIntOne((PsiElement)value);
        };
        TokenSet replaceableOperatorTypes2 = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS});
        TokenSet commutativeOperatorTypes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS});
        REPLACEABLE_ASSIGNMENT_CONDITION = new PhpReplaceableAssignmentCondition(replaceableOperatorTypes2, commutativeOperatorTypes, (Condition<? super PsiElement>)((Condition)PhpAssignmentReplaceableWithPrefixExpressionInspection::isLiteralIntOne));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/assignment/PhpAssignmentReplaceableWithPrefixExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/assignment/PhpAssignmentReplaceableWithPrefixExpressionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

