/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class PhpInvalidMagicMethodModifiersInspection
extends PhpInspection {
    private static final Set<String> PUBLIC_MAGIC_METHODS = new TreeSet<String>(String::compareToIgnoreCase){
        {
            this.addAll(Arrays.asList("__callStatic", "__set", "__call", "__get", "__isset", "__unset", "__toString", "__debugInfo", "__invoke"));
        }
    };

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInvalidMagicMethodModifiersInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PsiElement node;
                String name = method.getName();
                if (PUBLIC_MAGIC_METHODS.contains(name) && (node = method.getNameIdentifier()) != null) {
                    PhpModifier modifier = method.getModifier();
                    if ("__callStatic".equalsIgnoreCase(name)) {
                        if (!modifier.isPublic()) {
                            holder.registerProblem(node, PhpBundle.message("inspection.magic.method.visibility.must.be.public", name), new LocalQuickFix[]{PhpChangeMethodModifiersQuickFix.CHANGE_TO_PUBLIC_STATIC});
                        }
                        if (!modifier.isStatic()) {
                            holder.registerProblem(node, PhpBundle.message("inspection.magic.method.visibility.must.be.static", name), new LocalQuickFix[]{PhpChangeMethodModifiersQuickFix.CHANGE_TO_PUBLIC_STATIC});
                        }
                    } else {
                        if (!modifier.isPublic()) {
                            holder.registerProblem(node, PhpBundle.message("inspection.magic.method.visibility.must.be.public", name), new LocalQuickFix[]{PhpChangeMethodModifiersQuickFix.CHANGE_TO_PUBLIC});
                        }
                        if (modifier.isStatic()) {
                            holder.registerProblem(node, PhpBundle.message("inspection.magic.method.visibility.cannot.be.static", name), new LocalQuickFix[]{PhpChangeMethodModifiersQuickFix.CHANGE_TO_PUBLIC});
                        }
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpInvalidMagicMethodModifiersInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpInvalidMagicMethodModifiersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpInvalidMagicMethodModifiersInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

