/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayFilterToLoopQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpArrayFilterCanBeConvertedToLoopInspection
extends PhpInspection {
    public static boolean canBeCalledAsLambda(PsiElement element) {
        return element instanceof Variable || element instanceof StringLiteralExpression;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayFilterCanBeConvertedToLoopInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference arrayFilterCall) {
                if (!PhpArrayMapCanBeConvertedToLoopInspection.isGlobalFunctionCallWithName(arrayFilterCall, "array_filter")) {
                    return;
                }
                PsiElement[] arguments = arrayFilterCall.getParameters();
                if (arguments.length < 2) {
                    return;
                }
                Function closure = (Function)PhpPsiUtil.getChildByCondition(arguments[1], (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (PhpArrayFilterCanBeConvertedToLoopInspection.canBeCalledAsLambda(arguments[1]) || closure != null && PhpArrayMapCanBeConvertedToLoopInspection.hasNoUseByReferences(closure) && PsiTreeUtil.findChildrenOfType((PsiElement)closure, PhpReturn.class).size() == 1) {
                    holder.registerProblem(arrayFilterCall.getFirstChild(), PhpBundle.message("inspection.arrayfilter.can.be.converted.to.loop", new Object[0]), new LocalQuickFix[]{PhpConvertArrayFilterToLoopQuickFix.INSTANCE});
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpArrayFilterCanBeConvertedToLoopInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFilterCanBeConvertedToLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFilterCanBeConvertedToLoopInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

