/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.strictStandards;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpSignatureMismatchDuringInheritanceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpSignatureMismatchDuringInheritanceInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                for (Method method : clazz.getOwnMethods()) {
                    String name = method.getName();
                    if (PhpLangUtil.equalsMethodNames(name, "__construct") || method instanceof PhpDocMethod) continue;
                    PhpClass containingClass = method.getContainingClass();
                    PsiElement node = method.getNameIdentifier();
                    if (containingClass == null || containingClass.isTrait() || node == null || name.equalsIgnoreCase(containingClass.getName())) continue;
                    PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (classMember, superClass, baseClass) -> {
                        Method superMethod;
                        if (holder == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((superMethod = (Method)classMember) instanceof PhpDocMethod) {
                            return true;
                        }
                        PhpClass superContainingClass = classMember.getContainingClass();
                        if (superContainingClass == null || superContainingClass.isTrait()) {
                            return true;
                        }
                        Pair<Boolean, Parameter> result = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(superMethod, method);
                        if (!((Boolean)result.first).booleanValue()) {
                            PsiElement target;
                            PsiElement psiElement = target = result.second != null ? (PsiElement)result.second : node;
                            if (target.getContainingFile() == holder.getFile()) {
                                if (isOnTheFly) {
                                    String superName = PhpHierarchyChecksInspection.buildSuperName(superMethod, superContainingClass);
                                    holder.registerProblem(target, "Declaration should be compatible with " + superName, new LocalQuickFix[0]);
                                } else {
                                    holder.registerProblem(target, "Declaration should be compatible with super", new LocalQuickFix[0]);
                                }
                            }
                        }
                        return true;
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/strictStandards/PhpSignatureMismatchDuringInheritanceInspection$1", "lambda$visitPhpClass$0"));
            }
        };
        if (phpElementVisitor == null) {
            PhpSignatureMismatchDuringInheritanceInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSignatureMismatchDuringInheritanceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSignatureMismatchDuringInheritanceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

