/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGroupUseElement
implements Comparable<PhpGroupUseElement> {
    @Nullable
    public final String keyword;
    @NotNull
    public final String name;
    @Nullable
    public final String alias;

    public PhpGroupUseElement(@Nullable String keyword, @NotNull String name, @Nullable String alias) {
        if (name == null) {
            PhpGroupUseElement.$$$reportNull$$$0(0);
        }
        this.keyword = keyword;
        this.name = name;
        this.alias = alias;
    }

    public PhpGroupUseElement(@NotNull PhpUse use) {
        if (use == null) {
            PhpGroupUseElement.$$$reportNull$$$0(1);
        }
        this(use, use.getAliasName());
    }

    public PhpGroupUseElement(@NotNull PhpUse use, @Nullable String alias) {
        if (use == null) {
            PhpGroupUseElement.$$$reportNull$$$0(2);
        }
        this.keyword = StringUtil.nullize((String)PhpGroupUseElement.getKeyword(use, null));
        this.name = PhpUseImpl.getReferenceText(use);
        this.alias = alias;
    }

    @Override
    public int compareTo(PhpGroupUseElement o) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)this.keyword, (CharSequence)o.keyword)) {
            if (StringUtil.isEmpty((String)this.keyword)) {
                return -1;
            }
            if (StringUtil.isEmpty((String)o.keyword)) {
                return 1;
            }
            return o.keyword.length() - this.keyword.length();
        }
        int compare = PhpLangUtil.compareFQN(PhpLangUtil.toFQN(this.name), PhpLangUtil.toFQN(o.name));
        if (compare != 0) {
            return compare;
        }
        return StringUtil.compare((String)this.alias, (String)o.alias, (boolean)true);
    }

    public String toString() {
        return "PhpGroupUseElement{keyword='" + this.keyword + "', name='" + this.name + "', alias='" + this.alias + "'}";
    }

    @NotNull
    public static String getKeyword(@Nullable PhpUse use, @Nullable PhpUseList useList) {
        if (use != null && use.isOfConst() || useList != null && useList.isOfConst()) {
            String string = PhpUseKeyword.CONSTANT.getValue();
            if (string == null) {
                PhpGroupUseElement.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (use != null && use.isOfFunction() || useList != null && useList.isOfFunction()) {
            String string = PhpUseKeyword.FUNCTION.getValue();
            if (string == null) {
                PhpGroupUseElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = PhpUseKeyword.CLASS.getValue();
        if (string == null) {
            PhpGroupUseElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpGroupUseElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpGroupUseElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum PhpUseKeyword {
        CONSTANT("const"),
        FUNCTION("function"),
        CLASS("");

        private final String myValue;

        private PhpUseKeyword(String value) {
            this.myValue = value;
        }

        public String getValue() {
            return this.myValue;
        }
    }
}

