/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PhpUnitGroupsChooser {
    private final ListTableModel<GroupItem> myGroupsTableModel;
    private Set<String> myIncludedGroups = new HashSet<String>();
    private Set<String> myExcludedGroups = new HashSet<String>();
    private Set<String> myAdditionGroups = new HashSet<String>();
    private Boolean myCheckBoxSelected = false;
    private final TableView<GroupItem> myGroupsTableView;
    private static final int MAPPING_ROWS = 7;

    public PhpUnitGroupsChooser(TableView<GroupItem> groupsTableView) {
        this.myGroupsTableView = groupsTableView;
        this.myGroupsTableView.setShowGrid(false);
        this.myGroupsTableView.setShowVerticalLines(false);
        this.myGroupsTableView.setGridColor(this.myGroupsTableView.getForeground());
        this.myGroupsTableView.setRowHeight(new JTextField().getPreferredSize().height);
        Dimension scrollableSize = this.myGroupsTableView.getPreferredScrollableViewportSize();
        if (scrollableSize != null) {
            this.myGroupsTableView.setPreferredScrollableViewportSize(new Dimension(scrollableSize.width, this.myGroupsTableView.getRowHeight() * 7));
        }
        this.myGroupsTableView.setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setEnabled(PhpUnitGroupsChooser.this.myCheckBoxSelected != false && PhpUnitGroupsChooser.this.myGroupsTableView.isEnabled());
                return component;
            }
        });
        this.myGroupsTableView.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!((GroupItem)((PhpUnitGroupsChooser)PhpUnitGroupsChooser.this).myGroupsTableView.getItems().get((int)row)).valid) {
                    this.setForeground((Color)JBColor.RED);
                } else {
                    this.setForeground(JBColor.foreground());
                }
                rendererComponent.setEnabled(PhpUnitGroupsChooser.this.myCheckBoxSelected != false && PhpUnitGroupsChooser.this.myGroupsTableView.isEnabled());
                return rendererComponent;
            }
        });
        this.myGroupsTableModel = new ListTableModel(new ColumnInfo[]{new IncludeGroupColumn(PhpBundle.message("php.unit.include.group", new Object[0])), new ExcludeGroupColumn(PhpBundle.message("php.unit.exclude.group", new Object[0])), new ColumnInfo<GroupItem, String>(PhpBundle.message("php.unit.group.name", new Object[0])){

            public String valueOf(GroupItem groupItem) {
                return groupItem.groupName;
            }
        }});
        this.myGroupsTableView.setModelAndUpdateColumns(this.myGroupsTableModel);
        this.myGroupsTableView.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.myGroupsTableView.getColumn((Object)PhpBundle.message("php.unit.include.group", new Object[0])).setResizable(false);
        this.myGroupsTableView.setAutoResizeMode(3);
        this.myGroupsTableView.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean includeColumn = false;
                boolean excludeColumn = true;
                int[] selectedRows = PhpUnitGroupsChooser.this.myGroupsTableView.getSelectedRows();
                boolean allIncludeChosen = true;
                boolean allExcludeChosen = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !PhpUnitGroupsChooser.this.myGroupsTableView.isCellEditable(selectedRow, 0) || !PhpUnitGroupsChooser.this.myGroupsTableView.isCellEditable(selectedRow, 1)) {
                        return;
                    }
                    allIncludeChosen &= ((Boolean)PhpUnitGroupsChooser.this.myGroupsTableView.getValueAt(selectedRow, 0)).booleanValue();
                    allExcludeChosen &= ((Boolean)PhpUnitGroupsChooser.this.myGroupsTableView.getValueAt(selectedRow, 1)).booleanValue();
                }
                for (int selectedRow : selectedRows) {
                    if (allIncludeChosen) {
                        PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.FALSE, selectedRow, 0);
                        PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.TRUE, selectedRow, 1);
                        continue;
                    }
                    if (allExcludeChosen) {
                        PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.FALSE, selectedRow, 0);
                        PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.FALSE, selectedRow, 1);
                        continue;
                    }
                    PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.TRUE, selectedRow, 0);
                    PhpUnitGroupsChooser.this.myGroupsTableView.setValueAt((Object)Boolean.FALSE, selectedRow, 1);
                }
                PhpUnitGroupsChooser.this.myGroupsTableModel.fireTableChanged(new TableModelEvent((TableModel)PhpUnitGroupsChooser.this.myGroupsTableModel, selectedRows[0]));
                PhpUnitGroupsChooser.this.myGroupsTableView.repaint();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.resizeGroupsTableColumns();
    }

    private void resizeGroupsTableColumns() {
        for (int i = 0; i < this.myGroupsTableModel.getColumnCount(); ++i) {
            ColumnInfo columnInfo = this.myGroupsTableModel.getColumnInfos()[i];
            TableColumn column = this.myGroupsTableView.getColumn((Object)columnInfo.getName());
            if (columnInfo.getColumnClass() != Boolean.class) continue;
            String name = columnInfo.getName();
            FontMetrics fontMetrics = this.myGroupsTableView.getFontMetrics(this.myGroupsTableView.getFont());
            int width = fontMetrics.stringWidth(" " + name + " ") + 10;
            column.setWidth(width);
            column.setPreferredWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
        }
    }

    public void setIncludedExcludedGroups(Set<String> includedGroups, Set<String> excludedGroups) {
        this.myIncludedGroups = new HashSet<String>(includedGroups);
        this.myExcludedGroups = new HashSet<String>(excludedGroups);
        this.myAdditionGroups = new HashSet<String>(this.myIncludedGroups);
        this.myAdditionGroups.addAll(this.myExcludedGroups);
    }

    public Set<String> getIncludedGroups() {
        return this.myIncludedGroups;
    }

    public Set<String> getExcludedGroups() {
        return this.myExcludedGroups;
    }

    public void updateGroupsListModel(Collection<String> allGroups) {
        if (allGroups == null) {
            return;
        }
        HashMap<String, GroupItem> groupsMap = new HashMap<String, GroupItem>();
        for (String s : allGroups) {
            groupsMap.put(s, new GroupItem(s, false, false, true));
        }
        for (String s : this.myIncludedGroups) {
            if (!groupsMap.containsKey(s)) {
                groupsMap.put(s, new GroupItem(s, true, false, false));
                continue;
            }
            groupsMap.put(s, new GroupItem(s, true, false, true));
        }
        for (String s : this.myExcludedGroups) {
            if (!groupsMap.containsKey(s)) {
                groupsMap.put(s, new GroupItem(s, false, true, false));
                continue;
            }
            groupsMap.put(s, new GroupItem(s, false, true, true));
        }
        for (String s : this.myAdditionGroups) {
            if (groupsMap.containsKey(s)) continue;
            groupsMap.put(s, new GroupItem(s, false, false, false));
        }
        ArrayList items = new ArrayList(groupsMap.values());
        Collections.sort(items);
        this.myGroupsTableModel.setItems(items);
    }

    public void checkBoxSelectionChanged(Boolean newValue) {
        this.myCheckBoxSelected = newValue;
    }

    private class IncludeGroupColumn
    extends GroupBooleanColumn {
        IncludeGroupColumn(String name) {
            super(name);
        }

        public Boolean valueOf(GroupItem groupItem) {
            return groupItem.include;
        }

        public void setValue(GroupItem groupItem, Boolean value) {
            if (value.booleanValue() && groupItem.exclude) {
                groupItem.exclude = false;
                PhpUnitGroupsChooser.this.myExcludedGroups.remove(groupItem.groupName);
            }
            groupItem.include = value;
            if (value.equals(true)) {
                PhpUnitGroupsChooser.this.myIncludedGroups.add(groupItem.groupName);
            } else {
                PhpUnitGroupsChooser.this.myIncludedGroups.remove(groupItem.groupName);
            }
        }
    }

    private class ExcludeGroupColumn
    extends GroupBooleanColumn {
        ExcludeGroupColumn(String name) {
            super(name);
        }

        public Boolean valueOf(GroupItem groupItem) {
            return groupItem.exclude;
        }

        public void setValue(GroupItem groupItem, Boolean value) {
            if (value.booleanValue() && groupItem.include) {
                groupItem.include = false;
                PhpUnitGroupsChooser.this.myIncludedGroups.remove(groupItem.groupName);
            }
            groupItem.exclude = value;
            if (value.equals(true)) {
                PhpUnitGroupsChooser.this.myExcludedGroups.add(groupItem.groupName);
            } else {
                PhpUnitGroupsChooser.this.myExcludedGroups.remove(groupItem.groupName);
            }
        }
    }

    private abstract class GroupBooleanColumn
    extends ColumnInfo<GroupItem, Boolean> {
        GroupBooleanColumn(String name) {
            super(name);
        }

        public boolean isCellEditable(GroupItem groupItem) {
            return PhpUnitGroupsChooser.this.myCheckBoxSelected;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }
    }

    public class GroupItem
    implements Comparable {
        public String groupName;
        public boolean include;
        public boolean exclude;
        public boolean valid;

        public GroupItem(String _groupName, boolean _selected, boolean _exclude, boolean _valid) {
            this.groupName = _groupName;
            this.include = _selected;
            this.exclude = _exclude;
            this.valid = _valid;
        }

        public int compareTo(Object o) {
            return this.groupName.compareTo(((GroupItem)o).groupName);
        }
    }
}

