/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2.storage;

import com.intellij.util.containers.Interner;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XLeafMultitimeCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleCall;
import com.jetbrains.php.profiler.xdebug.model2.storage.XMiddleLongCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XModelStorage {
    public final Collection<XCall> myTreeRoots = new ArrayList<XCall>();
    public final List<XCall> myCalls = new ArrayList<XCall>();
    public final Interner<XCallable> myCallables = new Interner();
    public final Interner<XCall> myLeafCallsInterner = new Interner();

    public XCallable createOrGet(XCallable callable) {
        return (XCallable)this.myCallables.intern((Object)callable);
    }

    public int store(Collection<XCall> calls) {
        this.myCalls.addAll(calls);
        return this.myCalls.size();
    }

    public int getStorageSize() {
        return this.myCalls.size();
    }

    public void addTreeRoots(Collection<XCall> treeRoots) {
        this.myTreeRoots.addAll(treeRoots);
    }

    public Collection<XCall> getTreeRoots() {
        return this.myTreeRoots;
    }

    public XCall createMiddleCall(XCallable callable, Collection<XCall> children, long myOwnTime, long myCumulativeTime) {
        if (myCumulativeTime > Integer.MAX_VALUE || myOwnTime > Integer.MAX_VALUE) {
            return new XMiddleLongCall(callable, children, myOwnTime, myCumulativeTime, this);
        }
        return new XMiddleCall(callable, children, (int)myOwnTime, (int)myCumulativeTime, this);
    }

    public XCall createLeafCall(XCallable function, int ownTime) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafCall(function, ownTime));
    }

    public XCall createLeafMultitimeCall(XCallable callable, int myCumulativeTime, int invocationCount) {
        return (XCall)this.myLeafCallsInterner.intern((Object)new XLeafMultitimeCall(callable, myCumulativeTime, invocationCount));
    }
}

