/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extract.extractInterface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceHandler;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceUsageSearcher;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractInterfaceProcessor
extends PhpBaseRefactoringProcessor {
    private PhpExtractInterfaceUsageSearcher mySearcher;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor");
    private static final PhpFunctionCodeGenerator myFunctionDeclarationGenerator = new PhpFunctionCodeGenerator.PhpFunctionDeclarationGenerator(){

        @Override
        protected void appendFunctionPrefix(@NotNull StringBuilder builder, @NotNull Function function) {
            if (builder == null) {
                1.$$$reportNull$$$0(0);
            }
            if (function == null) {
                1.$$$reportNull$$$0(1);
            }
            assert (function instanceof Method);
            PhpModifier modifier = ((Method)function).getModifier();
            if (!modifier.isPublic() || 1.shouldAddVisibility((Method)function)) {
                PhpModifier newModifier = modifier.isStatic() ? PhpModifier.PUBLIC_IMPLEMENTED_STATIC : PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
                builder.append(newModifier.toString());
                builder.append(" ");
            } else if (modifier.isStatic()) {
                builder.append("static ");
            }
            builder.append("function ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceProcessor$1";
            objectArray[2] = "appendFunctionPrefix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final PhpClass myClass;
    private final String myInterfaceName;
    private final String myNamespaceName;
    private final boolean myReplaceClassReferences;
    private final PhpFileCreationInfo myFileConfiguration;
    private final List<? extends PhpMemberInfo> myMemberInfos;
    private final PhpDocRefactoringType myPhpDocRefactoring;

    protected PhpExtractInterfaceProcessor(@NotNull Project project, @NotNull PhpClass clazz, @NotNull String interfaceName, @NotNull String namespaceName, @NotNull PhpFileCreationInfo fileConfiguration, @NotNull List<? extends PhpMemberInfo> memberInfos, @NotNull PhpDocRefactoringType phpDocRefactoring, boolean replaceClassReferences) {
        if (project == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(1);
        }
        if (interfaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(2);
        }
        if (namespaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(3);
        }
        if (fileConfiguration == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(4);
        }
        if (memberInfos == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(5);
        }
        if (phpDocRefactoring == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(6);
        }
        super(project);
        this.myClass = clazz;
        this.myInterfaceName = interfaceName;
        this.myNamespaceName = namespaceName;
        this.myFileConfiguration = fileConfiguration;
        this.myMemberInfos = memberInfos;
        Collections.sort(this.myMemberInfos);
        this.myPhpDocRefactoring = phpDocRefactoring;
        this.myReplaceClassReferences = replaceClassReferences;
    }

    private PhpExtractInterfaceUsageSearcher getSearcher() {
        if (this.mySearcher == null) {
            this.mySearcher = new PhpExtractInterfaceUsageSearcher(this.myProject, this.myClass);
        }
        return this.mySearcher;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(7);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PhpClass[] phpClassArray = new PhpClass[]{PhpExtractInterfaceProcessor.this.myClass};
                if (phpClassArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return phpClassArray;
            }

            public String getProcessedElementsHeader() {
                return PhpExtractInterfaceHandler.REFACTORING_NAME;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceProcessor$2", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(8);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = this.getSearcher().findUsages();
        if (usageInfoArray == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(9);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        StringBuilder docMethods = new StringBuilder();
        PsiElement content = this.generateContent(this.myNamespaceName, docMethods);
        PsiFile file = PhpFileCreator.createPhpFileWithContent(this.myProject, this.myFileConfiguration.getBaseDirectory(), this.myFileConfiguration.getRelativePath(), content);
        if (file == null) {
            String targetDirectory = this.myFileConfiguration.getAbsolutePath();
            LOG.error(PhpBundle.message("refactoring.extract.interface.fail.to.create.file", targetDirectory));
            return;
        }
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        this.collectReferences(referenceResolver);
        PsiElement createdInterface = PhpExtractInterfaceProcessor.getFirstClassInFile((PhpFile)file);
        assert (createdInterface instanceof PhpClass);
        this.refactorSourceClass(docMethods);
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(createdInterface);
        if (scopeHolder != null) {
            referenceResolver.importReferences(scopeHolder, createdInterface);
        }
        PhpExtractInterfaceProcessor.addReferenceWithImport(this.myInterfaceName, this.myNamespaceName, (PsiElement)this.myClass, (Consumer<? super String>)((Consumer)s -> this.addImplementClause((String)s)));
        MultiMap toReformat = MultiMap.create();
        if (this.myReplaceClassReferences) {
            UsageInfo[] usagesInNewInterface;
            for (UsageInfo usage : usages) {
                this.processUsage(usage, (MultiMap<PsiFile, Integer>)toReformat);
            }
            for (UsageInfo usage : usagesInNewInterface = this.getSearcher().findUsages((SearchScope)new LocalSearchScope((PsiElement)file))) {
                this.processUsage(usage, null);
            }
            PhpExtractInterfaceProcessor.reformat(this.myProject, file, (MultiMap<PsiFile, Integer>)toReformat);
            this.optimizeImports(file);
        }
        PhpExtractInterfaceProcessor.reformat(this.myProject, file, (MultiMap<PsiFile, Integer>)toReformat);
        PhpCodeUtil.openRelatedFile(this.myProject, PhpExtractInterfaceProcessor.getFirstClassInFile((PhpFile)file));
    }

    @Override
    protected boolean forceOptimizeImports() {
        return true;
    }

    private void processUsage(@NotNull UsageInfo info, @Nullable MultiMap<PsiFile, Integer> toReformat) {
        PsiReference reference;
        if (info == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(10);
        }
        if ((reference = info.getReference()) != null) {
            PsiElement element = reference.getElement();
            PhpExtractInterfaceProcessor.addReferenceWithImport(this.myInterfaceName, this.myNamespaceName, element, (Consumer<? super String>)((Consumer)fqn -> {
                if (element instanceof PhpDocPsiElement) {
                    TextRange range = reference.getRangeInElement();
                    String elementText = element.getText();
                    String tail = elementText.length() > range.getEndOffset() ? elementText.substring(range.getEndOffset()) : "";
                    PhpDocType type = PhpPsiElementFactory.createPhpDocType(this.myProject, fqn + tail);
                    PsiElement newElement = element.replace((PsiElement)type);
                    PsiFile file = newElement.getContainingFile();
                    if (toReformat != null) {
                        toReformat.putValue((Object)file, (Object)newElement.getTextRange().getStartOffset());
                    }
                } else {
                    ClassReference ref = PhpPsiElementFactory.createClassReference(this.myProject, fqn);
                    element.replace((PsiElement)ref);
                }
            }));
        }
    }

    private void collectReferences(@NotNull PhpClassReferenceResolver referenceResolver) {
        PhpDocComment comment;
        if (referenceResolver == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(11);
        }
        if (this.copyPhpDoc() && (comment = this.myClass.getDocComment()) != null) {
            referenceResolver.processElement((PsiElement)comment);
        }
        for (PhpMemberInfo phpMemberInfo : this.myMemberInfos) {
            Parameter[] parameters;
            PhpDocComment comment2;
            PhpClassMember member = (PhpClassMember)phpMemberInfo.getMember();
            assert (member instanceof Method);
            if (this.copyPhpDoc() && (comment2 = member.getDocComment()) != null) {
                referenceResolver.processElement((PsiElement)comment2);
            }
            Method method = (Method)member;
            for (Parameter parameter : parameters = method.getParameters()) {
                referenceResolver.processElement((PsiElement)parameter, false);
            }
            PhpReturnType returnType = method.getReturnType();
            if (returnType == null) continue;
            referenceResolver.processElement((PsiElement)returnType);
        }
    }

    private void refactorSourceClass(StringBuilder docMethods) {
        boolean moveComment = this.myPhpDocRefactoring == PhpDocRefactoringType.MOVE;
        for (PhpMemberInfo phpMemberInfo : this.myMemberInfos) {
            Object oldModifier;
            PhpClassMember member = (PhpClassMember)phpMemberInfo.getMember();
            assert (member instanceof Method);
            PhpModifier modifier = member.getModifier();
            if (!modifier.isPublic() && (oldModifier = PhpPsiUtil.getChildByCondition((PsiElement)member, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF)) != null) {
                PhpModifier newModifier = PhpModifier.instance((PhpModifier.Access)PhpModifier.Access.PUBLIC, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState());
                PhpPsiElement newModifierElement = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpElementTypes.MODIFIER_LIST, "class A {" + newModifier + " function foo() {}}");
                oldModifier.replace((PsiElement)newModifierElement);
            }
            if (this.willDeleteMethod(member)) {
                PhpExtractInterfaceProcessor.deleteMethod(member);
                continue;
            }
            if (!moveComment || member instanceof PhpDocMethod) continue;
            PhpExtractInterfaceProcessor.deleteComment((PhpNamedElement)member);
        }
        if (moveComment) {
            if (docMethods.length() > 0) {
                PhpExtractInterfaceProcessor.replaceComment((PhpNamedElement)this.myClass, docMethods);
            } else {
                PhpExtractInterfaceProcessor.deleteComment((PhpNamedElement)this.myClass);
            }
        }
    }

    private boolean willDeleteMethod(@NotNull PhpClassMember method) {
        if (method == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(12);
        }
        return this.myClass.isInterface() && method.getContainingClass() == this.myClass;
    }

    private static void deleteMethod(@NotNull PhpClassMember member) {
        if (member == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(13);
        }
        PhpDocComment comment = member.getDocComment();
        PsiElement parent = member.getParent();
        if (comment == null) {
            parent.deleteChildRange((PsiElement)member, (PsiElement)member);
        } else if (comment.getParent() == parent) {
            parent.deleteChildRange((PsiElement)comment, (PsiElement)member);
        } else {
            parent.deleteChildRange((PsiElement)member, (PsiElement)member);
            comment.getParent().deleteChildRange((PsiElement)comment, (PsiElement)comment);
        }
    }

    private static void deleteComment(@NotNull PhpNamedElement element) {
        PhpDocComment comment;
        if (element == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(14);
        }
        if ((comment = element.getDocComment()) != null) {
            PsiElement parent = comment.getParent();
            parent.deleteChildRange((PsiElement)comment, (PsiElement)comment);
        }
    }

    private static void replaceComment(@NotNull PhpNamedElement element, StringBuilder docMethods) {
        PhpDocComment comment;
        if (element == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(15);
        }
        if ((comment = element.getDocComment()) != null) {
            PhpDocComment newComment = PhpPsiElementFactory.createFromText(element.getProject(), PhpDocComment.class, docMethods.toString() + "\nclass A {}");
            if (newComment != null) {
                comment.replace((PsiElement)newComment);
            } else {
                PsiElement parent = comment.getParent();
                parent.deleteChildRange((PsiElement)comment, (PsiElement)comment);
            }
        }
    }

    private boolean copyPhpDoc() {
        return this.myPhpDocRefactoring != PhpDocRefactoringType.DO_NOTHING;
    }

    private static void addReferenceWithImport(@NotNull String interfaceName, @NotNull String namespaceName, @NotNull PsiElement element, @NotNull Consumer<? super String> consumer) {
        if (interfaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(16);
        }
        if (namespaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(17);
        }
        if (element == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(19);
        }
        String interfaceFqn = PhpLangUtil.toFQN(namespaceName + "\\" + interfaceName);
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scopeHolder == null) {
            return;
        }
        String alias = PhpCodeInsightUtil.alreadyImported(scopeHolder, interfaceFqn);
        if (alias != null) {
            consumer.consume((Object)alias);
        } else {
            boolean isNameAvailable = PhpCodeInsightUtil.canImport(scopeHolder, interfaceFqn);
            if (!isNameAvailable) {
                consumer.consume((Object)interfaceFqn);
            } else {
                boolean autoImport = PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder);
                if (autoImport) {
                    consumer.consume((Object)interfaceName);
                    PhpAliasImporter.insertUseStatement(interfaceFqn, scopeHolder);
                } else {
                    consumer.consume((Object)interfaceFqn);
                }
            }
        }
    }

    private void addImplementClause(@NotNull String interfaceName) {
        if (interfaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(20);
        }
        if (this.myClass.isInterface()) {
            ExtendsList extendsList = this.myClass.getExtendsList();
            if (StringUtil.isEmpty((String)extendsList.getText())) {
                String text = "class A extends " + interfaceName + " {}";
                PhpPsiElement newExtendsList = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpElementTypes.EXTENDS_LIST, text);
                PsiElement identifier = this.myClass.getNameIdentifier();
                this.myClass.addAfter((PsiElement)newExtendsList, identifier);
            } else {
                this.addToImplementList(interfaceName, (PsiElement)extendsList);
            }
        } else {
            ImplementsList implementsList = this.myClass.getImplementsList();
            if (StringUtil.isEmpty((String)implementsList.getText())) {
                String text = "class A implements " + interfaceName + " {}";
                PhpPsiElement newImplementsList = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpElementTypes.IMPLEMENTS_LIST, text);
                PsiElement whitespace = PhpExtractInterfaceProcessor.getAnchorBeforeImplList(newImplementsList);
                ExtendsList extendsList = this.myClass.getExtendsList();
                if (!StringUtil.isEmpty((String)extendsList.getText())) {
                    this.myClass.addRangeAfter(whitespace, (PsiElement)newImplementsList, (PsiElement)extendsList);
                } else {
                    PsiElement identifier = this.myClass.getNameIdentifier();
                    if (identifier == null) {
                        PsiElement beforeElement = PhpExtractInterfaceProcessor.getAnchorBeforeImplList((PhpPsiElement)implementsList);
                        PsiElement anchorPrevSibling = beforeElement instanceof PsiWhiteSpace ? beforeElement.getPrevSibling() : beforeElement;
                        if (anchorPrevSibling != null) {
                            this.myClass.addRangeAfter(whitespace, (PsiElement)newImplementsList, anchorPrevSibling);
                        }
                    } else {
                        this.myClass.addRangeAfter(whitespace, (PsiElement)newImplementsList, identifier);
                    }
                }
            } else {
                this.addToImplementList(interfaceName, (PsiElement)implementsList);
            }
        }
    }

    @Nullable
    private static PsiElement getAnchorBeforeImplList(PhpPsiElement newImplementsList) {
        PsiElement whitespace = newImplementsList.getPrevSibling();
        if (whitespace instanceof ExtendsList) {
            whitespace = whitespace.getPrevSibling();
        }
        return whitespace;
    }

    private void addToImplementList(@NotNull String interfaceName, @NotNull PsiElement list) {
        if (interfaceName == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(21);
        }
        if (list == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(22);
        }
        ClassReference classReference = PhpPsiElementFactory.createClassReference(this.myProject, interfaceName);
        this.myClass.addAfter((PsiElement)classReference, list);
        PsiElement comma = PhpPsiElementFactory.createComma(this.myProject);
        this.myClass.addAfter(comma, list);
    }

    protected static void reformat(@NotNull Project project, @NotNull PsiFile file, @NotNull MultiMap<PsiFile, Integer> toReformat) {
        if (project == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(23);
        }
        if (file == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(24);
        }
        if (toReformat == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(25);
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(file.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        for (Map.Entry entry : toReformat.entrySet()) {
            PsiFile containingFile = (PsiFile)entry.getKey();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
            if (document == null) continue;
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            ArrayList<TextRange> ranges = new ArrayList<TextRange>(((Collection)entry.getValue()).size());
            for (Integer offset : (Collection)entry.getValue()) {
                PsiElement elementAt = containingFile.findElementAt(offset.intValue());
                Object docComment = elementAt == null ? null : PhpPsiUtil.getParentByCondition(elementAt, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
                if (docComment == null) continue;
                ranges.add(docComment.getTextRange());
            }
            CodeStyleManager.getInstance((Project)project).reformatText(containingFile, ranges);
        }
    }

    @NotNull
    private static PsiElement getFirstClassInFile(@NotNull PhpFile file) {
        Collection<PhpClass> classes;
        if (file == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(26);
        }
        PsiElement psiElement = (classes = PhpPsiUtil.findAllClasses(file)).isEmpty() ? file.getFirstChild() : (PsiElement)classes.iterator().next();
        if (psiElement == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    @NotNull
    private PsiElement generateContent(@Nullable String namespaceName, StringBuilder docMethods) {
        String interfaceText = this.generateInterfaceText(docMethods);
        if (StringUtil.isNotEmpty((String)namespaceName)) {
            String namespaceText = "namespace " + namespaceName + ";\n\n" + interfaceText;
            PhpPsiElement phpPsiElement = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpStubElementTypes.NAMESPACE, namespaceText);
            if (phpPsiElement == null) {
                PhpExtractInterfaceProcessor.$$$reportNull$$$0(28);
            }
            return phpPsiElement;
        }
        PhpPsiElement phpPsiElement = PhpPsiElementFactory.createPhpPsiFromText(this.myProject, PhpStubElementTypes.CLASS, interfaceText);
        if (phpPsiElement == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(29);
        }
        return phpPsiElement;
    }

    @NotNull
    private String generateInterfaceText(@NotNull StringBuilder docMethods) {
        PhpDocComment comment;
        if (docMethods == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(30);
        }
        StringBuilder builder = new StringBuilder();
        if (this.copyPhpDoc() && (comment = this.myClass.getDocComment()) != null) {
            builder.append("\n");
            builder.append(comment.getText());
            builder.append("\n");
        }
        builder.append("interface ");
        builder.append(this.myInterfaceName);
        builder.append(" { ");
        for (PhpMemberInfo phpMemberInfo : this.myMemberInfos) {
            PhpDocComment comment2;
            PhpClassMember member = (PhpClassMember)phpMemberInfo.getMember();
            if ((this.copyPhpDoc() || this.willDeleteMethod(member)) && !(member instanceof PhpDocMethod) && (comment2 = member.getDocComment()) != null) {
                builder.append("\n");
                PhpDocReturnTag returnTag = comment2.getReturnTag();
                PhpType newDocReturnType = null;
                if (returnTag != null) {
                    PhpClass superClass;
                    PsiElement docType = PhpPsiUtil.getNextSiblingIgnoreWhitespace(returnTag.getFirstChild(), true);
                    newDocReturnType = returnTag.getType();
                    if (docType != null && "parent".equalsIgnoreCase(docType.getText()) && (superClass = this.myClass.getSuperClass()) != null) {
                        newDocReturnType = superClass.getType();
                    }
                    if (docType != null && "self".equalsIgnoreCase(docType.getText())) {
                        newDocReturnType = this.myClass.getType();
                    }
                }
                builder.append(this.getTransformedDoc(comment2, newDocReturnType));
                builder.append("\n");
            }
            assert (member instanceof Method);
            if (member instanceof PhpDocMethod) {
                if (this.myPhpDocRefactoring != PhpDocRefactoringType.MOVE) continue;
                if (docMethods.length() == 0) {
                    docMethods.append("\n/**");
                }
                docMethods.append("\n* ").append(member.getParent().getText());
                continue;
            }
            PhpReturnType returnType = ((Function)member).getReturnType();
            String methodDeclaration = myFunctionDeclarationGenerator.generate((Function)member, returnType != null ? this.getTypeText((PsiElement)returnType) : null);
            builder.append(methodDeclaration);
            builder.append("; ");
        }
        if (docMethods.length() > 0) {
            docMethods.append("\n*/\n");
        }
        if (this.myPhpDocRefactoring != PhpDocRefactoringType.MOVE) {
            builder.insert(0, docMethods.toString());
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(31);
        }
        return string;
    }

    private String getTypeText(@NotNull PsiElement returnType) {
        if (returnType == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(32);
        }
        if ("self".equalsIgnoreCase(returnType.getText())) {
            return PhpDocUtil.getTypePresentation(returnType.getProject(), this.myClass.getType(), null);
        }
        if ("parent".equalsIgnoreCase(returnType.getText())) {
            return PhpDocUtil.getTypePresentation(returnType.getProject(), this.myClass.getSuperClass().getType(), null);
        }
        return returnType.getText();
    }

    private String getTransformedDoc(@NotNull PhpDocComment comment, @Nullable PhpType returnType) {
        String commentText;
        if (comment == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(33);
        }
        PhpDocReturnTag returnTag = comment.getReturnTag();
        String newDocText = commentText = comment.getText();
        if (returnTag != null && returnType != null) {
            String updatedReturnPresentation = PhpDocUtil.getTypePresentation(comment.getProject(), returnType, null);
            newDocText = this.transformReturnTag(comment, returnTag, commentText, updatedReturnPresentation);
        }
        return newDocText;
    }

    @NotNull
    private String transformReturnTag(@NotNull PhpDocComment comment, PhpDocReturnTag returnTag, String commentText, String returnTypePresentation) {
        if (comment == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(34);
        }
        int globalOffset = comment.getTextRange().getStartOffset();
        TextRange returnTagTextRange = returnTag.getTextRange();
        String newDocText = commentText.substring(0, returnTagTextRange.getStartOffset() - globalOffset);
        newDocText = this.checkTag(returnTag) ? newDocText + "@return " + returnTypePresentation : newDocText + commentText.substring(returnTagTextRange.getStartOffset() - globalOffset, returnTagTextRange.getEndOffset() - globalOffset);
        String string = newDocText = newDocText + commentText.substring(returnTagTextRange.getEndOffset() - globalOffset);
        if (string == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(35);
        }
        return string;
    }

    private boolean checkTag(PhpDocReturnTag returnTag) {
        PsiElement type = PhpPsiUtil.getNextSiblingIgnoreWhitespace(returnTag.getFirstChild(), true);
        return type != null && ("self".equalsIgnoreCase(type.getText()) || this.myInterfaceName.equalsIgnoreCase(type.getText()) || "parent".equalsIgnoreCase(type.getText()));
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpExtractInterfaceHandler.REFACTORING_NAME;
        if (string == null) {
            PhpExtractInterfaceProcessor.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpDocRefactoring";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 9: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceResolver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReformat";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docMethods";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstClassInFile";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateContent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInterfaceText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "transformReturnTag";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processUsage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "willDeleteMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteComment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceComment";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceWithImport";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addImplementClause";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addToImplementList";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFirstClassInFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateInterfaceText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTransformedDoc";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "transformReturnTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum PhpDocRefactoringType {
        DO_NOTHING,
        COPY,
        MOVE;

    }
}

