/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import com.jetbrains.php.refactoring.inline.function.InlineInputData;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionHandler;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import com.jetbrains.php.refactoring.inline.function.ReplacementData;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineFunctionProcessor
extends BaseRefactoringProcessor {
    private static final Key<String> PHP_INLINE_MARK_KEY = Key.create((String)"");
    private final Function myFunction;
    @Nullable
    private final FunctionReference myReference;
    private final boolean myInlineThisFunctionUsageOnly;
    private final boolean myIsDeleteTheDeclaration;
    final PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();

    public PhpInlineFunctionProcessor(Project project, Function function, @Nullable FunctionReference reference, boolean invokeThisOnly, boolean isDeleteTheDeclaration) {
        super(project);
        this.myFunction = function;
        this.myReference = reference;
        this.myInlineThisFunctionUsageOnly = invokeThisOnly;
        this.myIsDeleteTheDeclaration = isDeleteTheDeclaration;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(0);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PhpInlineFunctionProcessor.this.myFunction};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"all.invocations.in.project");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(1);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myInlineThisFunctionUsageOnly) {
            assert (this.myReference != null);
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myReference.getElement())};
            if (usageInfoArray == null) {
                PhpInlineFunctionProcessor.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myFunction.getProject());
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)this.myFunction, (SearchScope)scope, false);
        UsageInfo[] usageInfoArray = (UsageInfo[])ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).findAll().stream().map(UsageInfo::new).toArray(UsageInfo[]::new);
        if (usageInfoArray == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(4);
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.invokeProcess(usages, this.myInlineThisFunctionUsageOnly, this.myIsDeleteTheDeclaration);
        }
        finally {
            a.finish();
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpBundle.message("refactoring.inline.function.command", this.getElementDescription());
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static Collection<FunctionReference> addBraces(Collection<? extends FunctionReference> references) {
        final ArrayList<FunctionReference> newReferences = new ArrayList<FunctionReference>();
        for (FunctionReference functionReference : references) {
            functionReference.putCopyableUserData(PHP_INLINE_MARK_KEY, (Object)"");
        }
        for (FunctionReference functionReference : references) {
            Statement statement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (statement == null) continue;
            PsiElement parent = statement.getParent();
            if (parent instanceof ControlStatement || parent instanceof Else) {
                PhpRefactoringUtil.wrapWithBraces(functionReference.getProject(), statement).accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                    public void visitPhpFunctionCall(FunctionReference reference) {
                        if (reference.getCopyableUserData(PHP_INLINE_MARK_KEY) != null) {
                            newReferences.add(reference);
                            reference.putCopyableUserData(PHP_INLINE_MARK_KEY, null);
                        }
                        super.visitPhpFunctionCall(reference);
                    }
                });
                continue;
            }
            newReferences.add(functionReference);
        }
        for (FunctionReference functionReference : references) {
            functionReference.putCopyableUserData(PHP_INLINE_MARK_KEY, null);
        }
        return newReferences;
    }

    public void invokeProcess(UsageInfo[] usages, boolean inlineThisOnly, boolean deleteDeclaration) {
        if (inlineThisOnly) {
            FunctionReference functionReference = PhpInlineFunctionProcessor.addBraces((Collection<? extends FunctionReference>)new SmartList((Object)this.myReference)).iterator().next();
            PsiFile file = functionReference.getContainingFile();
            ArrayList<TextRange> rangeToReformat = new ArrayList<TextRange>(this.doReplacement(functionReference));
            PhpInlineFunctionProcessor.commitAndFormat(this.myProject, file, rangeToReformat);
        } else {
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            ArrayList<FunctionReference> bracedFunctionReferences = new ArrayList();
            for (UsageInfo it : usages) {
                if (!(it.getElement() instanceof FunctionReference)) continue;
                bracedFunctionReferences.add((FunctionReference)it.getElement());
            }
            bracedFunctionReferences = PhpInlineFunctionProcessor.addBraces(bracedFunctionReferences);
            this.doReplacement(bracedFunctionReferences);
            if (deleteDeclaration) {
                this.myFunction.delete();
            }
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(6);
        }
        MultiMap conflicts = new MultiMap();
        for (UsageInfo it : (UsageInfo[])refUsages.get()) {
            if (!(it.getElement() instanceof FunctionReference)) continue;
            conflicts.putAllValues(PhpInlineFunctionHandler.validateFunctionContext(this.myFunction, (FunctionReference)it.getElement()));
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    public void doReplacement(Collection<FunctionReference> functionReferences) {
        for (FunctionReference it : functionReferences) {
            Object useStatement = PhpPsiUtil.getParentByCondition((PsiElement)it, true, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useStatement != null) {
                useStatement.delete();
                continue;
            }
            Collection<TextRange> ranges = this.doReplacement(it);
            PhpInlineFunctionProcessor.commitAndFormat(this.myProject, it.getContainingFile(), ranges);
        }
    }

    Map<Integer, String> createAssignmentsHeader(Collection<Integer> access, Function function, FunctionReference functionReference) {
        HashMap<Integer, String> guardingAssignments = new HashMap<Integer, String>();
        for (Integer it : access) {
            guardingAssignments.put(it, PhpInlineFunctionProcessor.getUniqueName((PsiElement)functionReference, function.getParameters()[it].getName(), ContainerUtil.set((Object[])function.getParameters())));
        }
        return guardingAssignments;
    }

    static Collection<Integer> collectParametersWithWriteAccess(final Function function) {
        final ArrayDeque<Integer> result = new ArrayDeque<Integer>();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                Parameter[] parameters = function.getParameters();
                int counter = 0;
                for (Parameter it : parameters) {
                    if (variable.resolve() == it && variable.isWriteAccess() && !it.isPassByRef()) {
                        result.add(counter);
                    }
                    ++counter;
                }
                super.visitPhpVariable(variable);
            }
        });
        return result;
    }

    private ReplacementData createReplacement(InlineInputData inputData, Map<Integer, String> guardingAssignments) {
        boolean lastReturn;
        Parameter[] parameters = inputData.myFunction.getParameters();
        HashMap<RangeMarker, String> replaceMap = new HashMap<RangeMarker, String>();
        Ref parentInlined = new Ref();
        parentInlined.set((Object)false);
        LinkedHashSet<PhpNamedElement> namedElementsToImport = new LinkedHashSet<PhpNamedElement>();
        HashMap<PhpNamedElement, String> aliases = new HashMap<PhpNamedElement, String>();
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)inputData.myFunctionReference);
        Set<String> usedNames = PhpInlineFunctionProcessor.collectUsedNames(scopeHolder);
        DocumentImpl document = new DocumentImpl(inputData.myFunction.getText());
        this.processInternalReferences(inputData, guardingAssignments, (Document)document, parameters, replaceMap, namedElementsToImport, aliases, scopeHolder, usedNames);
        ArrayList<Statement> statementsList = new ArrayList<Statement>();
        if (!guardingAssignments.isEmpty()) {
            guardingAssignments.forEach((key, value) -> statementsList.add(PhpPsiElementFactory.createStatement(this.myProject, String.format("$%s = %s;", guardingAssignments.get(key), inputData.parameterExpressions[key].getText()))));
        }
        this.referenceResolver.processElements(statementsList);
        replaceMap.forEach((arg_0, arg_1) -> PhpInlineFunctionProcessor.lambda$createReplacement$2((Document)document, arg_0, arg_1));
        Function functionReplacement = PhpPsiElementFactory.createFunction(this.myProject, document.getText());
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)functionReplacement, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (groupStatement != null);
        PsiElement[] groupStatementStatements = groupStatement.getStatements();
        final ArrayList returnStatements = new ArrayList();
        functionReplacement.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                returnStatements.add(returnStatement);
                super.visitPhpReturn(returnStatement);
            }

            public void visitPhpFunction(Function function) {
                if (function.isClosure()) {
                    return;
                }
                super.visitPhpFunction(function);
            }
        });
        PhpExpression toInline = null;
        if (returnStatements.size() > 1 || returnStatements.size() == 1 && !(groupStatementStatements[groupStatementStatements.length - 1] instanceof PhpReturn)) {
            String returnVar = PhpInlineFunctionProcessor.getUniqueName((PsiElement)inputData.myFunctionReference, inputData.myFunction.getName(), new HashSet());
            returnStatements.forEach(e -> {
                PsiElement returnArgument = e.getArgument();
                if (returnArgument != null) {
                    e.replace((PsiElement)PhpPsiElementFactory.createStatement(this.myProject, "$" + returnVar + "=" + returnArgument.getText() + ";"));
                }
            });
            toInline = PhpPsiElementFactory.createFromText(this.myProject, PhpExpression.class, "$" + returnVar);
        }
        functionReplacement = (Function)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)functionReplacement);
        GroupStatement groupStatementToInline = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)functionReplacement, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        assert (groupStatementToInline != null);
        PsiElement[] statements = groupStatementToInline.getStatements();
        int last = statements.length - 1;
        boolean bl = lastReturn = returnStatements.size() == 1 && statements[last] instanceof PhpReturn;
        if (lastReturn) {
            toInline = ((PhpReturn)statements[last]).getArgument();
        }
        PsiElement child = groupStatementToInline.getFirstChild();
        if ((child = child.getNextSibling()) instanceof PsiWhiteSpace) {
            child = child.getNextSibling();
        }
        ArrayList<PsiElement> functionsStatements = new ArrayList<PsiElement>();
        while (child != null) {
            PsiElement sibling;
            if (!(lastReturn && child == statements[last] || (sibling = child.getNextSibling()) == null || child instanceof PsiWhiteSpace && sibling == groupStatementToInline.getLastChild())) {
                functionsStatements.add(child);
            }
            child = child.getNextSibling();
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument((Document)document);
        return new ReplacementData((PsiElement)toInline, functionsStatements, returnStatements.size() >= 1, statementsList, namedElementsToImport, aliases);
    }

    private void processInternalReferences(final InlineInputData inputData, final Map<Integer, String> guardingAssignments, final Document document, final Parameter[] parameters, final Map<RangeMarker, String> replaceMap, final Collection<PhpNamedElement> namedElementsToImport, final Map<PhpNamedElement, String> aliases, final PhpPsiElement scopeHolder, final Set<String> usedNames) {
        inputData.myFunction.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                int counter = 0;
                for (Parameter it : parameters) {
                    if (variable.resolve() == it) {
                        if (counter < inputData.parameterExpressions.length) {
                            this.replaceParameterWithArgumentValue(variable, counter);
                        } else {
                            this.replaceParameterUsageWithDefaultValue(variable, counter);
                        }
                    }
                    ++counter;
                }
                super.visitPhpVariable(variable);
            }

            private PsiElement replaceDefaultValueWithContextIndependent(PsiElement element) {
                PsiElement resolve;
                PhpExpression expression;
                if (element instanceof MemberReference && (expression = ((MemberReference)element).getClassReference()) instanceof ClassReference && (resolve = ((ClassReference)expression).resolve()) instanceof PhpClass) {
                    String name = PhpInlineFunctionProcessor.this.getNameForClassReference((PhpClass)resolve, scopeHolder);
                    return PhpPsiElementFactory.createFromText(PhpInlineFunctionProcessor.this.myProject, MemberReference.class, name + element.getText().substring(expression.getTextLength()));
                }
                return element;
            }

            private void replaceParameterWithArgumentValue(Variable variable, int counter) {
                replaceMap.put(document.createRangeMarker(variable.getTextRange().shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), guardingAssignments.get(counter) != null ? PhpPsiElementFactory.createVariable(PhpInlineFunctionProcessor.this.myProject, (String)guardingAssignments.get(counter), true).getText() : inputData.parameterExpressions[counter].getText());
            }

            private void replaceParameterUsageWithDefaultValue(Variable variable, int counter) {
                PsiElement value = parameters[counter].getDefaultValue();
                if (value != null) {
                    replaceMap.put(document.createRangeMarker(variable.getTextRange().shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), this.replaceDefaultValueWithContextIndependent(value).getText());
                }
            }

            public void visitPhpFunctionCall(FunctionReference functionReference) {
                Function function;
                PsiElement resolve = functionReference.resolve();
                if (resolve instanceof Function && !((function = (Function)resolve) instanceof Method)) {
                    this.prepareReplacementWithImport((PhpReference)functionReference, (PhpNamedElement)function, usedNames);
                }
                super.visitPhpFunctionCall(functionReference);
            }

            public void visitPhpConstantReference(ConstantReference constantReference) {
                if (!PhpLangUtil.isNull(constantReference)) {
                    PsiElement resolve = constantReference.resolve();
                    if (resolve instanceof PhpNamedElement) {
                        this.prepareReplacementWithImport((PhpReference)constantReference, (PhpNamedElement)resolve, usedNames);
                    }
                    super.visitPhpConstantReference(constantReference);
                }
            }

            public void visitPhpClassReference(ClassReference classReference) {
                PsiElement resolve;
                String name = classReference.getName();
                ASTNode nameNode = classReference.getNameNode();
                if (name != null && nameNode != null && (resolve = classReference.resolve()) instanceof PhpClass) {
                    TextRange nameRange = new TextRange(classReference.getTextRange().getStartOffset(), nameNode.getTextRange().getEndOffset());
                    String className = PhpInlineFunctionProcessor.this.getNameForClassReference((PhpClass)resolve, scopeHolder);
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), className);
                }
                super.visitPhpClassReference(classReference);
            }

            private void prepareReplacementWithImport(PhpReference reference, PhpNamedElement resolve, Set<String> usedNames2) {
                String notImportedName;
                ASTNode nameNode = reference.getNameNode();
                assert (nameNode != null);
                TextRange nameRange = new TextRange(reference.getTextRange().getStartOffset(), nameNode.getTextRange().getEndOffset());
                String string = notImportedName = resolve.getNamespaceName().equals(inputData.myFunctionReference.getNamespaceName()) ? resolve.getName() : resolve.getFQN();
                if (PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder)) {
                    String importedName;
                    if (namedElementsToImport.add(resolve)) {
                        String elementName = resolve.getName();
                        if (usedNames2.contains(elementName)) {
                            String aliasName;
                            importedName = aliasName = this.getAliasName(usedNames2, elementName);
                            aliases.put(resolve, aliasName);
                        } else {
                            importedName = elementName;
                        }
                    } else {
                        String aliasName = (String)aliases.get(resolve);
                        importedName = aliasName != null ? aliasName : resolve.getName();
                    }
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), importedName);
                } else {
                    replaceMap.put(document.createRangeMarker(nameRange.shiftLeft(inputData.myFunction.getTextRange().getStartOffset())), notImportedName);
                }
            }

            @Nullable
            String getAliasName(@Nullable Collection<String> usedNames2, @NotNull String name) {
                if (name == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (usedNames2 != null) {
                    String aliasName = name;
                    int counter = 1;
                    while (usedNames2.contains(aliasName)) {
                        aliasName = name + counter++;
                    }
                    usedNames2.add(aliasName);
                    return aliasName;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor$5", "getAliasName"));
            }
        });
    }

    @NotNull
    private String getNameForClassReference(PhpClass resolve, PhpPsiElement scopeHolder) {
        String className = PhpCodeInsightUtil.isAutoImportEnabled(scopeHolder) ? resolve.getName() : (PhpCodeInsightUtil.isSameNamespace(scopeHolder, resolve.getFQN()) ? resolve.getName() : resolve.getFQN());
        String string = className;
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static Set<String> collectUsedNames(PhpPsiElement scopeHolder) {
        HashSet<String> usedNames = new HashSet<String>();
        List<PhpUseList> useLists = null;
        if (scopeHolder != null) {
            useLists = PhpCodeInsightUtil.collectImports(scopeHolder);
        }
        if (useLists != null) {
            for (PhpUseList list : useLists) {
                PhpUse[] declarations;
                for (PhpUse declaration : declarations = list.getDeclarations()) {
                    String name = declaration.getName();
                    String aliasName = declaration.getAliasName();
                    if (aliasName != null) {
                        usedNames.add(aliasName);
                        continue;
                    }
                    usedNames.add(name);
                }
            }
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public static String getUniqueName(PsiElement position, String variableName, Set<? extends Parameter> parameters) {
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(position, false, null);
        Set<String> usedNames = declarations.stream().map(element -> element.getName()).collect(Collectors.toSet());
        Set strings = ContainerUtil.map2Set(parameters, e -> e.getName());
        usedNames.addAll(strings);
        List name = ContainerUtil.newSmartList((Object)variableName);
        PhpNameUtil.unique(name, usedNames);
        return (String)name.get(0);
    }

    public static void importIfNeeded(@NotNull PhpPsiElement scopeForUseOperator, PhpNamedElement namedElement, String alias) {
        String fqn;
        if (scopeForUseOperator == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(9);
        }
        if (PhpCodeInsightUtil.isSameNamespace(scopeForUseOperator, fqn = namedElement.getFQN())) {
            return;
        }
        String importKeyword = null;
        if (namedElement instanceof Function) {
            importKeyword = "function";
        } else if (namedElement instanceof Constant) {
            importKeyword = "const";
        }
        PhpAliasImporter.insertUseStatementWithKeyword(importKeyword, fqn, alias, scopeForUseOperator);
    }

    public Collection<TextRange> doReplacement(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(10);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(functionReference.getContainingFile());
        Collection<Integer> writeAccess = PhpInlineFunctionProcessor.collectParametersWithWriteAccess(this.myFunction);
        Map<Integer, String> guardingAssignments = this.createAssignmentsHeader(writeAccess, this.myFunction, functionReference);
        ReplacementData functionReplacement = this.createReplacement(new InlineInputData(functionReference, this.myFunction), guardingAssignments);
        Statement statement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)functionReference);
        assert (statement != null && document != null && scopeHolder != null);
        this.referenceResolver.processElement((PsiElement)this.myFunction);
        for (PhpNamedElement namedElement : functionReplacement.myNamedElementsToImport) {
            PhpInlineFunctionProcessor.importIfNeeded(scopeHolder, namedElement, functionReplacement.myAliases.get(namedElement));
        }
        PsiElement parent = statement.getParent();
        Collection rangeToReformat = functionReplacement.myGuardingAssignemnts.stream().map(it -> parent.addBefore((PsiElement)it, (PsiElement)statement)).map(PsiElement::getTextRange).collect(Collectors.toList());
        if (!functionReplacement.myFunctionStatements.isEmpty()) {
            PsiElement firstElement = null;
            for (PsiElement it2 : functionReplacement.myFunctionStatements) {
                PsiElement element = parent.addBefore(it2, (PsiElement)statement);
                if (firstElement != null) continue;
                firstElement = element;
            }
        }
        if (functionReplacement.myIsReturn && functionReplacement.myExpressionToInline != null) {
            rangeToReformat.add(functionReference.replace(functionReplacement.myExpressionToInline).getTextRange());
        } else if (functionReplacement.myExpressionToInline == null) {
            statement.delete();
        }
        this.referenceResolver.importReferences(scopeHolder, parent);
        return rangeToReformat;
    }

    public static void commitAndFormat(@NotNull Project project, PsiFile file, Collection<? extends TextRange> rangeToReformat) {
        Document document;
        if (project == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(11);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            if (rangeToReformat != null) {
                rangeToReformat.forEach(range -> {
                    if (project == null) {
                        PhpInlineFunctionProcessor.$$$reportNull$$$0(13);
                    }
                    CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset());
                });
            }
        }
    }

    @NotNull
    String getElementDescription() {
        String string = PhpInlineFunctionPresenter.getElementDescription(this.myFunction, false);
        if (string == null) {
            PhpInlineFunctionProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void lambda$createReplacement$2(Document document, RangeMarker e, String v) {
        document.replaceString(e.getStartOffset(), e.getEndOffset(), (CharSequence)v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForClassReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "importIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doReplacement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "commitAndFormat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitAndFormat$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

