/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceParameter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportConstantQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportFunctionQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.inplace.PhpInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.inplace.PhpParameterInplaceIntroduceFacade;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterDialog;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterPresenter;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceParameterHandler
extends PhpIntroduceVariableHandler {
    private static void processUsages(PhpIntroduceContext introduceContext, Project project, Collection<PsiReference> references, Map<String, Constant> constantReferenceToDeclaration, Map<String, Function> functionCallToDeclaration) {
        for (PsiReference reference : references) {
            PhpIntroduceParameterHandler.processUsage(introduceContext, project, reference, constantReferenceToDeclaration, functionCallToDeclaration);
        }
    }

    private static void processUsage(PhpIntroduceContext introduceContext, Project project, PsiReference reference, Map<String, Constant> constantReferenceToDeclaration, Map<String, Function> functionCallToDeclaration) {
        FunctionReference fr;
        ParameterList frParameterList;
        Object functionReference;
        PsiElement logicalElement = introduceContext.getLogicalElement();
        String parameterText = logicalElement.getText();
        if (reference instanceof PhpCallbackReferenceBase && (functionReference = PhpPsiUtil.getParentByCondition(reference.getElement(), (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) instanceof PsiReference) {
            reference = (PsiReference)functionReference;
        }
        if (reference instanceof FunctionReference && (frParameterList = (fr = (FunctionReference)reference).getParameterList()) != null) {
            int length = frParameterList.getParameters().length;
            String text = "<?php \n foo(" + frParameterList.getText() + (length > 0 ? ", " : "") + parameterText + ");";
            ParameterList parameterList = PhpPsiElementFactory.createFirstFromText(project, ParameterList.class, text);
            if (parameterList != null) {
                frParameterList.replace((PsiElement)parameterList);
                PsiElement[] newParams = fr.getParameters();
                newParams[newParams.length - 1].accept((PsiElementVisitor)new ImportingVisitor(constantReferenceToDeclaration, functionCallToDeclaration));
            }
        }
    }

    @Override
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.parameter.name", new Object[0]);
    }

    @Override
    @NotNull
    protected PhpIntroduceParameterPresenter getPresenter(PhpIntroduceContext introduceContext) {
        PhpIntroduceParameterPresenter phpIntroduceParameterPresenter = new PhpIntroduceParameterPresenter(new PhpIntroduceParameterDialog(introduceContext.getProject()), this, introduceContext);
        if (phpIntroduceParameterPresenter == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        return phpIntroduceParameterPresenter;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        return PhpCodeValidationUtil.isAllowedAsParameterValue(expression);
    }

    @Override
    protected boolean isSupportedScope(@NotNull PsiElement scope, @NotNull PsiElement expression) {
        if (scope == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        if (element == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{Function.class, Method.class});
    }

    @Override
    protected PsiElement doRefactoring(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        String name = settings.getName();
        Project project = introduceContext.getProject();
        Parameter parameter = PhpPsiElementFactory.createParameter(project, name);
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        Function f = (Function)PhpPsiUtil.getParentByCondition(introduceContext.getPhysicalElement(), (Condition<? super PsiElement>)Function.INSTANCEOF);
        THashMap constReferenceToDeclaration = new THashMap();
        THashMap functionCallToDeclaration = new THashMap();
        introduceContext.getContext().accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Map)constReferenceToDeclaration, (Map)functionCallToDeclaration){
            final /* synthetic */ Map val$constReferenceToDeclaration;
            final /* synthetic */ Map val$functionCallToDeclaration;
            {
                this.val$constReferenceToDeclaration = map;
                this.val$functionCallToDeclaration = map2;
            }

            public void visitPhpConstantReference(ConstantReference constantReference) {
                PsiElement resolve = constantReference.resolve();
                if (resolve instanceof Constant) {
                    this.val$constReferenceToDeclaration.put(constantReference.getName(), (Constant)resolve);
                }
                super.visitPhpConstantReference(constantReference);
            }

            public void visitPhpFunctionCall(FunctionReference functionReference) {
                PsiElement resolve = functionReference.resolve();
                if (resolve instanceof Function) {
                    this.val$functionCallToDeclaration.put(functionReference.getName(), (Function)resolve);
                }
                super.visitPhpFunctionCall(functionReference);
            }
        });
        PsiElement result = physicalElement.replace(expressionForOriginalElement);
        if (f != null) {
            PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)f, PhpElementTypes.PARAMETER_LIST);
            result = PhpChangeSignatureProcessor.addParameter(parameterList, parameter);
            PhpChangeSignatureUsageProcessor.fixPhpDoc(f, false);
            Collection references = ReferencesSearch.search((PsiElement)f).findAll();
            PhpIntroduceParameterHandler.processUsages(introduceContext, project, references, (Map<String, Constant>)constReferenceToDeclaration, (Map<String, Function>)functionCallToDeclaration);
            PhpIntroduceVariableHandler.replaceOccurrences(introduceContext, settings, expressionForOriginalElement);
        }
        return result;
    }

    @Override
    @Nullable
    protected PhpInplaceIntroduceFacade<PhpIntroduceVariableSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        return new PhpParameterInplaceIntroduceFacade(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpIntroduceParameterHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresenter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpIntroduceParameterHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportingVisitor
    extends PhpRecursiveElementVisitor {
        Map<String, Constant> constReferenceToDeclaration;
        Map<String, Function> functionCallToDeclaration;

        ImportingVisitor(Map<String, Constant> constReferenceToDeclaration, Map<String, Function> functionCallToDeclaration) {
            this.constReferenceToDeclaration = constReferenceToDeclaration;
            this.functionCallToDeclaration = functionCallToDeclaration;
        }

        public void visitPhpConstantReference(ConstantReference reference) {
            Constant definition = this.constReferenceToDeclaration.get(reference.getName());
            if (definition != null) {
                PhpImportConstantQuickFix.INSTANCE.applyFix(reference.getProject(), (PhpReference)reference, definition);
            }
            super.visitPhpConstantReference(reference);
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            Function definition = this.functionCallToDeclaration.get(reference.getName());
            if (definition != null) {
                PhpImportFunctionQuickFix.INSTANCE.applyFix(reference.getProject(), (PhpReference)reference, definition);
            }
            super.visitPhpFunctionCall(reference);
        }
    }
}

