/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassUsageInfo
extends UsageInfo {
    protected PhpMoveClassUsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(0);
        }
        super(element);
    }

    protected PhpMoveClassUsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(1);
        }
        super(reference);
    }

    @Nullable
    protected PsiFile secondStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(2);
        }
        if (namespaceName == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(4);
        }
        return (element = this.getElement()) == null ? null : element.getContainingFile();
    }

    protected void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(5);
        }
        if (namespaceName == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(7);
        }
    }

    protected static void commitAndReformat(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(9);
        }
        if (document == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(10);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PhpMoveClassUsageInfo.reformatFile(project, file);
        psiDocumentManager.commitDocument(document);
        TextRange range = file.getTextRange();
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, range);
    }

    protected static void reformatFile(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(11);
        }
        if (file == null) {
            PhpMoveClassUsageInfo.$$$reportNull$$$0(12);
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(file.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
    }

    public static boolean importIfNeeded(PhpPsiElement scopeHolder, String fqn) {
        if (InternalNamespaceUsage.alreadyImported(scopeHolder, fqn)) {
            return true;
        }
        if (PhpCodeInsightUtil.canImport(scopeHolder, fqn)) {
            PhpAliasImporter.insertUseStatement(fqn, scopeHolder);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "secondStepProcess";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "firstStepProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "commitAndReformat";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpDocClassReferenceUsage
    extends InternalNamespaceUsage {
        private final boolean myIsMoved;

        public PhpDocClassReferenceUsage(@NotNull PsiReference reference, boolean isMoved) {
            if (reference == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(0);
            }
            super(reference);
            this.myIsMoved = isMoved;
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            if (project == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                PhpDocClassReferenceUsage.$$$reportNull$$$0(3);
            }
            if (this.myIsMoved) {
                return;
            }
            PsiElement element = this.getElement();
            if (element != null) {
                PsiElement namespaceReference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                if (namespaceReference != null) {
                    super.firstStepProcess(project, namespaceName, clazz);
                } else {
                    boolean importSucceeded = PhpDocClassReferenceUsage.addImportIfPossible(element, namespaceName, clazz.getName());
                    if (!importSucceeded) {
                        PhpNamespaceReference newReference = PhpDocClassReferenceUsage.constructNamespaceReference(project, element, namespaceName);
                        element.getParent().addBefore((PsiElement)newReference, element);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$PhpDocClassReferenceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CallbackClassUsage
    extends PhpMoveClassUsageInfo {
        public CallbackClassUsage(@NotNull PsiElement element) {
            if (element == null) {
                CallbackClassUsage.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            int startIndex;
            if (project == null) {
                CallbackClassUsage.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                CallbackClassUsage.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                CallbackClassUsage.$$$reportNull$$$0(3);
            }
            PsiElement element = this.getElement();
            assert (element instanceof StringLiteralExpression);
            String oldText = element.getText();
            boolean isQuoted = StringUtil.isQuotedString((String)oldText);
            int index = oldText.indexOf("\\");
            boolean isSeparatorEscaped = 0 < index && index < oldText.length() - 1 && oldText.charAt(index + 1) == '\\';
            String separator = isSeparatorEscaped ? StringUtil.escapeBackSlashes((String)"\\") : "\\";
            StringBuilder builder = new StringBuilder();
            int n = startIndex = isQuoted ? 1 : 0;
            if (oldText.length() > startIndex + 1 && "\\".equals(String.valueOf(oldText.charAt(startIndex)))) {
                builder.append(separator);
            }
            String preparedNamespaceName = StringUtil.trimEnd((String)namespaceName, (String)"\\");
            if (isSeparatorEscaped) {
                preparedNamespaceName = StringUtil.escapeBackSlashes((String)preparedNamespaceName);
            }
            builder.append(preparedNamespaceName);
            if (!PhpLangUtil.isGlobalNamespaceName(preparedNamespaceName)) {
                builder.append(separator);
            }
            builder.append(clazz.getNameCS());
            if (isQuoted) {
                StringUtil.quote((StringBuilder)builder, (char)oldText.charAt(0));
            }
            StringLiteralExpression callback = PhpPsiElementFactory.createPhpPsiFromText(project, StringLiteralExpression.class, builder.toString());
            element.replace((PsiElement)callback);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$CallbackClassUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ExternalNamespaceUsage
    extends PhpMoveClassUsageInfo {
        public ExternalNamespaceUsage(@NotNull PsiReference reference) {
            if (reference == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(0);
            }
            super(reference);
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            PsiElement element;
            if (project == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(3);
            }
            if ((element = this.getElement()) != null) {
                PhpUseList useList = PhpUseImpl.getUseList(element);
                if (useList == null || useList.isTraitImport()) {
                    PsiElement reference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                    if (reference != null) {
                        reference.replace((PsiElement)ExternalNamespaceUsage.constructNamespaceReference(project, element, namespaceName));
                    }
                } else {
                    PhpCodeEditUtil.replaceNamespaceReferenceForUse(namespaceName, element, useList.getDeclarations().length == 1);
                }
            }
        }

        protected static PhpNamespaceReference constructNamespaceReference(@NotNull Project project, @Nullable PsiElement element, @NotNull String namespaceName) {
            if (project == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(4);
            }
            if (namespaceName == null) {
                ExternalNamespaceUsage.$$$reportNull$$$0(5);
            }
            PhpPsiElement scopeHolder = element == null ? null : PhpCodeInsightUtil.findScopeForUseOperator(element);
            String fqn = PhpLangUtil.toFQN(namespaceName);
            String qualifiedName = scopeHolder == null || !(element instanceof ClassReference) ? fqn : PhpCodeInsightUtil.createQualifiedName(scopeHolder, fqn, (PhpReference)((ClassReference)element), true, true);
            return PhpPsiElementFactory.createPhpPsiFromText(project, PhpNamespaceReference.class, "new " + qualifiedName + "\\A();");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$ExternalNamespaceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "constructNamespaceReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InternalNamespaceUsage
    extends ExternalNamespaceUsage {
        public InternalNamespaceUsage(@NotNull PsiReference reference) {
            if (reference == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(0);
            }
            super(reference);
        }

        @Override
        public void firstStepProcess(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
            PsiElement element;
            if (project == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(1);
            }
            if (namespaceName == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(3);
            }
            if ((element = this.getElement()) != null) {
                PsiElement namespaceReference = PhpPsiUtil.getChildOfType(element, PhpElementTypes.NS_REFERENCE);
                if (namespaceReference != null) {
                    super.firstStepProcess(project, namespaceName, clazz);
                } else {
                    PsiElement identifier;
                    boolean importSucceeded = InternalNamespaceUsage.addImportIfPossible(element, namespaceName, clazz.getName());
                    if (!importSucceeded && (identifier = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.IDENTIFIER)) != null) {
                        PhpNamespaceReference newReference = InternalNamespaceUsage.constructNamespaceReference(project, element, namespaceName);
                        element.addBefore((PsiElement)newReference, identifier);
                    }
                }
            }
        }

        public static boolean addImportIfPossible(@NotNull PsiElement element, @NotNull String namespace, String className) {
            String fqn;
            PhpPsiElement scopeHolder;
            if (element == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(4);
            }
            if (namespace == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(5);
            }
            return (scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element)) != null && InternalNamespaceUsage.importIfNeeded(scopeHolder, fqn = PhpLangUtil.toFQN(namespace + "\\" + className));
        }

        public static boolean alreadyImported(@NotNull PhpPsiElement scopeHolder, @NotNull String fqn) {
            if (scopeHolder == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(6);
            }
            if (fqn == null) {
                InternalNamespaceUsage.$$$reportNull$$$0(7);
            }
            if (PhpCodeInsightUtil.isSameNamespace(scopeHolder, fqn)) {
                return true;
            }
            List<PhpUseList> lists = PhpCodeInsightUtil.collectImports(scopeHolder);
            for (PhpUseList list : lists) {
                Object[] declarations = list.getDeclarations();
                if (ArrayUtil.isEmpty((Object[])declarations)) {
                    return false;
                }
                for (Object declaration : declarations) {
                    PhpReference reference = declaration.getTargetReference();
                    if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), fqn)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeHolder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfo$InternalNamespaceUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "firstStepProcess";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addImportIfPossible";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "alreadyImported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

