/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberDelegate
extends MoveHandlerDelegate {
    public static final String REFACTORING_NAME = PhpBundle.message("refactoring.move.member.title", new Object[0]);

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (PhpMoveMemberDelegate.extractMemberToMove(element, PhpMoveMemberDelegate.available(element.getParent())) != null) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer);
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public void doMove(Project project, PhpClassMember member, Editor editor) {
        if (PhpMoveMemberDelegate.available((PsiElement)member)) {
            PhpClass fromClass = member.getContainingClass();
            if (fromClass != null) {
                PhpMemberInfoStorage memberInfoStorage = new PhpMemberInfoStorage(fromClass);
                for (PhpMemberInfo memberIt : memberInfoStorage.getClassMemberInfos((PsiElement)fromClass)) {
                    if (!fromClass.getManager().areElementsEquivalent(memberIt.getMember(), (PsiElement)member)) continue;
                    memberIt.setChecked(true);
                    break;
                }
                PhpMoveMemberDialog dialog = new PhpMoveMemberDialog(project, fromClass, memberInfoStorage, editor);
                dialog.show();
            }
        } else {
            String message = null;
            if (PhpMoveMemberDelegate.isAbstractAndStatic(member)) {
                message = PhpBundle.message("refactoring.move.members.refactoring.method.declaration.is.not.correct", new Object[0]);
            }
            if (message != null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            }
        }
    }

    protected static boolean available(PsiElement element) {
        if (!(element instanceof PhpClassMember)) {
            return false;
        }
        PhpClassMember member = (PhpClassMember)element;
        return member.getModifier().isStatic() && !PhpMoveMemberDelegate.isAbstractAndStatic(member);
    }

    private static boolean isAbstractAndStatic(PhpClassMember member) {
        return member instanceof Method && ((Method)member).isStatic() && ((Method)member).isAbstract();
    }

    @Nullable
    public static PhpClassMember extractMemberToMove(@NotNull PsiElement element, boolean available) {
        int caretOffset;
        PsiElement sibling;
        Editor editor;
        FileEditorManager editorManager;
        PsiFile file;
        PsiElement parent;
        PsiElement identifier;
        if (element == null) {
            PhpMoveMemberDelegate.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = identifier = (parent = element.getParent()) instanceof PhpClassMember ? ((PhpClassMember)parent).getNameIdentifier() : null;
        if (identifier == null && (file = element.getContainingFile()) != null && (editorManager = FileEditorManager.getInstance((Project)file.getProject())) != null && (editor = editorManager.getSelectedTextEditor()) != null && (sibling = file.findElementAt((caretOffset = editor.getCaretModel().getOffset()) - 1)) != null) {
            element = sibling;
            parent = element.getParent();
            PsiElement psiElement2 = identifier = parent instanceof PhpClassMember && available ? ((PhpClassMember)parent).getNameIdentifier() : null;
        }
        if (identifier == null) {
            return null;
        }
        return (PhpClassMember)(identifier == element || identifier == element.getPrevSibling() || identifier == element.getNextSibling() ? parent : null);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        PhpClassMember method = PhpMoveMemberDelegate.extractMemberToMove(element, PhpMoveMemberDelegate.available(element.getParent()));
        if (method != null) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)PhpBundle.message("refactoring.common.file.read.only", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
                return PhpMoveMemberDelegate.available((PsiElement)method);
            }
            this.doMove(project, method, editor);
            return PhpMoveMemberDelegate.available((PsiElement)method);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDelegate", "extractMemberToMove"));
    }
}

