/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;

public class PhpVisibilityPanel
extends VisibilityPanelBase<String> {
    public static final String AS_IS = "AS_IS";
    private JRadioButton myAsIsRb;
    private JRadioButton myPrivateRb;
    private JRadioButton myProtectedRb;
    private JRadioButton myPublicRb;
    private JPanel myContentPane;
    private ButtonGroup myButtonGroup;
    private final Map<JRadioButton, String> myVisibilities;

    public PhpVisibilityPanel() {
        this.$$$setupUI$$$();
        this.myVisibilities = new HashMap<JRadioButton, String>();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.myContentPane, "Center");
        ((GridLayoutManager)this.myContentPane.getLayout()).setVGap(0);
        this.myVisibilities.put(this.myAsIsRb, AS_IS);
        this.myVisibilities.put(this.myPublicRb, PhpModifier.Access.PUBLIC.toString());
        this.myVisibilities.put(this.myProtectedRb, PhpModifier.Access.PROTECTED.toString());
        this.myVisibilities.put(this.myPrivateRb, PhpModifier.Access.PRIVATE.toString());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpVisibilityPanel.this.stateChanged(new ChangeEvent((Object)PhpVisibilityPanel.this));
            }
        };
        Enumeration<AbstractButton> e = this.myButtonGroup.getElements();
        while (e.hasMoreElements()) {
            e.nextElement().addActionListener(listener);
        }
    }

    public String getVisibility() {
        for (JRadioButton button : this.myVisibilities.keySet()) {
            if (!button.isSelected()) continue;
            return this.myVisibilities.get(button);
        }
        assert (false) : "None of the buttons is selected";
        return null;
    }

    @NotNull
    public List<String> visibilities() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myVisibilities.values());
        if (arrayList == null) {
            PhpVisibilityPanel.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void setVisibility(String visibility) {
        for (Map.Entry<JRadioButton, String> entry : this.myVisibilities.entrySet()) {
            if (!Comparing.equal((String)visibility, (String)entry.getValue())) continue;
            entry.getKey().setSelected(true);
            return;
        }
        assert (false) : "Unknown visibility: " + visibility;
    }

    public void setVisible(boolean value) {
        super.setVisible(value);
        this.myContentPane.setVisible(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/ui/PhpVisibilityPanel", "visibilities"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/RefactoringBundle").getString("visibility.border.title"), (int)0, (int)0, null, null));
        this.myAsIsRb = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/RefactoringBundle").getString("visibility.as.is"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrivateRb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("visibility.private"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRb = jRadioButton2 = new JRadioButton();
        jRadioButton2.setHideActionText(false);
        jRadioButton2.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("visibility.protected"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicRb = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("visibility.public"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

