/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.unwrap;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTryUnwrapper
extends PhpUnwrapper {
    public PhpTryUnwrapper() {
        super(PhpBundle.message("unwrap.try", new Object[0]));
    }

    @Override
    protected void doUnwrap(PsiElement element, PhpUnwrapper.Context context) throws IncorrectOperationException {
        assert (element instanceof Try);
        Try tryStatement2 = (Try)element;
        Finally finallyBlock = tryStatement2.getFinallyBlock();
        if (finallyBlock != null) {
            GroupStatement gs = (GroupStatement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            GroupStatement gsFinally = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)finallyBlock, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (gsFinally != null && gs != null) {
                context.extractGroupStatement(this, gs, element);
                context.extractGroupStatement(this, gsFinally, element);
                context.delete(element);
            }
        } else {
            super.doUnwrap(element, context);
        }
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            PhpTryUnwrapper.$$$reportNull$$$0(0);
        }
        return e instanceof Try;
    }

    @Override
    @Nullable
    public IElementType getClosingElementType() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/refactoring/unwrap/PhpTryUnwrapper", "isApplicableTo"));
    }
}

