/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpNamespaceByFilesProvider
implements PhpNamespaceProvider {
    public static final PhpNamespaceProvider INSTANCE = new PhpNamespaceByFilesProvider();

    private PhpNamespaceByFilesProvider() {
    }

    @Override
    public List<String> suggestNamespaces(@NotNull PsiDirectory directory) {
        PsiFile[] files;
        if (directory == null) {
            PhpNamespaceByFilesProvider.$$$reportNull$$$0(0);
        }
        for (PsiFile file : files = directory.getFiles()) {
            if (!(file instanceof PhpFile)) continue;
            List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces((PsiFile)((PhpFile)file));
            if (namespaces.isEmpty()) {
                return GLOBAL_NAMESPACE;
            }
            PhpNamespace namespace = namespaces.get(0);
            String fqn = namespace.getFQN();
            return fqn == null ? GLOBAL_NAMESPACE : ContainerUtil.newSmartList((Object)PhpLangUtil.toPresentableFQN(fqn));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/php/roots/PhpNamespaceByFilesProvider", "suggestNamespaces"));
    }
}

