/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDefaultNameInterpretersCollectorHelper {
    private static final PhpDefaultNameInterpretersCollectorHelper ourDefaultNameCollector = new PhpDefaultNameInterpretersCollectorHelper();
    private static final String EXTENDED_NAME = "extended";
    private static final String DEFAULT_NAME = "default";
    protected static final String LOCAL = "local";

    @NotNull
    public Set<UsageDescriptor> collectUsages(@Nullable Project project) {
        boolean isProjectLevel = project != null;
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        if (manager == null) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(0);
            }
            return set;
        }
        THashSet usages = new THashSet();
        List<PhpInterpreter> localInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(interpreter -> !interpreter.isRemote()).collect(Collectors.toList());
        this.collectUsages(project, null, localInterpreters, (Set<UsageDescriptor>)usages);
        Map remoteInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(sdk -> sdk.getSdkAdditionalData() instanceof RemoteSdkAdditionalData).collect(Collectors.groupingBy(sdk -> ((RemoteSdkAdditionalData)sdk.getSdkAdditionalData()).getRemoteConnectionType(), Collectors.mapping(Function.identity(), Collectors.toList())));
        for (Map.Entry entry : remoteInterpreters.entrySet()) {
            this.collectUsages(project, entry.getKey(), entry.getValue(), (Set<UsageDescriptor>)usages);
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    protected void collectUsages(@Nullable Project project, @Nullable CredentialsType type, @NotNull List<PhpInterpreter> interpreters, @NotNull Set<UsageDescriptor> usages) {
        if (interpreters == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(3);
        }
        List notDefault = interpreters.stream().filter(interpreter -> !PhpDefaultNameInterpretersCollectorHelper.isDefaultName(project, interpreter)).collect(Collectors.toList());
        int numNotDefault = notDefault.size();
        int numExtendedDefault = (Integer)notDefault.stream().filter(interpreter -> PhpDefaultNameInterpretersCollectorHelper.isExtendedDefaultName(project, interpreter)).collect(MoreCollectors.countingInt());
        String name = type != null ? PhpDefaultNameInterpretersCollectorHelper.escapeUsageKey(type.getName()) : LOCAL;
        usages.add(new UsageDescriptor(name + "-" + DEFAULT_NAME, interpreters.size() - numNotDefault));
        usages.add(new UsageDescriptor(name + "-" + EXTENDED_NAME, numExtendedDefault));
        usages.add(new UsageDescriptor(name, numNotDefault - numExtendedDefault));
    }

    @NotNull
    protected static String escapeUsageKey(@NotNull String key) {
        if (key == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(4);
        }
        String string = StringUtil.replace((String)key.toLowerCase(), (String)" ", (String)"-");
        if (string == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(6);
        }
        String name = interpreter.getName();
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(name);
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        if (StringUtil.equals((CharSequence)suggested, (CharSequence)name)) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)name, (CharSequence)suggested) && PhpDefaultNameInterpretersCollectorHelper.isCounterPrefix(name, suggested.length());
    }

    private static boolean isCounterPrefix(@NotNull String name, int prefixStart) {
        int nameLength;
        if (name == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(7);
        }
        if ((nameLength = name.length()) <= prefixStart + 3) {
            return false;
        }
        if (name.charAt(nameLength - 1) == ')' && name.charAt(prefixStart) == ' ' && name.charAt(prefixStart + 1) == '(') {
            String count = name.substring(prefixStart + 2, nameLength - 1);
            try {
                return Integer.valueOf(count) > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isExtendedDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(8);
        }
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName());
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        return StringUtil.containsIgnoreCase((String)interpreter.getName(), (String)suggested);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsages";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeUsageKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeUsageKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCounterPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedDefaultName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        private static final String GROUP_ID = "statistics.php.interpreters.default.name.ide";

        @NotNull
        public Set<UsageDescriptor> getUsages() {
            Set<UsageDescriptor> set = ourDefaultNameCollector.collectUsages(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            if (GROUP_ID == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(1);
            }
            return GROUP_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ApplicationUsageCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ProjectUsageCollector
    extends ProjectUsagesCollector {
        private static final String GROUP_ID = "statistics.php.interpreters.default.name.project";

        @NotNull
        public Set<UsageDescriptor> getUsages(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<UsageDescriptor> set = ourDefaultNameCollector.collectUsages(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        @NotNull
        public String getGroupId() {
            if (GROUP_ID == null) {
                ProjectUsageCollector.$$$reportNull$$$0(2);
            }
            return GROUP_ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUsages";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

