/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.lib.ComposerLibraryManager;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpIncludePathUsagesCollector
extends ProjectUsagesCollector {
    private static final String GROUP_ID = "statistics.php.include.path.custom";

    @NotNull
    public String getGroupId() {
        if (GROUP_ID == null) {
            PhpIncludePathUsagesCollector.$$$reportNull$$$0(0);
        }
        return GROUP_ID;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        PhpIncludePathManager includePathManager;
        if (project == null) {
            PhpIncludePathUsagesCollector.$$$reportNull$$$0(1);
        }
        if (!project.isDefault() && (includePathManager = PhpIncludePathManager.getInstance(project)) != null) {
            List<String> includePath = includePathManager.getIncludePath();
            int allPaths = 0;
            int allAbsolutePaths = 0;
            int nonComposerPaths = 0;
            if (!includePath.isEmpty()) {
                VirtualFile vendorDir = ComposerLibraryManager.getInstance(project).refreshVendorDir(false, null);
                String vendor = vendorDir == null ? null : vendorDir.getPath();
                for (String path : includePath) {
                    ++allPaths;
                    if (FileUtil.isAbsolute((String)path)) {
                        ++allAbsolutePaths;
                        if (vendor != null && FileUtil.isAncestor((String)vendor, (String)path, (boolean)true)) continue;
                        ++nonComposerPaths;
                        continue;
                    }
                    ++nonComposerPaths;
                }
            }
            Set set = ContainerUtil.set((Object[])new UsageDescriptor[]{new UsageDescriptor("non_composer_" + PhpIncludePathUsagesCollector.getValueOf(nonComposerPaths), 1), new UsageDescriptor("absolute_" + PhpIncludePathUsagesCollector.getValueOf(allAbsolutePaths), 1), new UsageDescriptor("relative_" + PhpIncludePathUsagesCollector.getValueOf(allPaths - allAbsolutePaths), 1), new UsageDescriptor("all_" + PhpIncludePathUsagesCollector.getValueOf(allPaths), 1)});
            if (set == null) {
                PhpIncludePathUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            PhpIncludePathUsagesCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static String getValueOf(int paths) {
        if (paths < 10) {
            return String.valueOf(paths);
        }
        if (paths < 20) {
            return "10-20";
        }
        if (paths < 40) {
            return "20-40";
        }
        if (paths < 100) {
            return "40-100";
        }
        return "100-...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpIncludePathUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpIncludePathUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

