/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.testFramework.PhpTestDescriptor;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class PhpSuffixBasedTestDescriptor
implements PhpTestDescriptor {
    @Override
    @NotNull
    public Collection<PhpClass> findTests(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(0);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)clazz.getProject());
        String className = clazz.getName();
        Collection collection = this.getNameSuffixes().stream().flatMap(suffix -> phpIndex.getClassesByName(className + suffix).stream()).collect(Collectors.toList());
        if (collection == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PhpClass> findClasses(@NotNull PhpClass test, @NotNull String testName) {
        if (test == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(2);
        }
        if (testName == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(3);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)test.getProject());
        Collection collection = this.getNameSuffixes().stream().filter(suffix -> {
            if (testName == null) {
                PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(7);
            }
            return StringUtil.endsWith((CharSequence)testName, (CharSequence)suffix);
        }).flatMap(suffix -> {
            if (testName == null) {
                PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(6);
            }
            return phpIndex.getClassesByName(testName.substring(0, testName.length() - suffix.length())).stream();
        }).collect(Collectors.toList());
        if (collection == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public boolean isTestClassName(@NotNull String name) {
        if (name == null) {
            PhpSuffixBasedTestDescriptor.$$$reportNull$$$0(5);
        }
        for (String suffix : this.getNameSuffixes()) {
            if (!StringUtil.endsWith((CharSequence)name, (CharSequence)suffix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<String> getNameSuffixes();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpSuffixBasedTestDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpSuffixBasedTestDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findTests";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTests";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTestClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClasses$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClasses$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

