/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="configuration_by_sdk")
public class PhpTestFrameworkBySdkConfiguration
extends PhpTestFrameworkConfigurationIml
implements PhpSdkDependentConfiguration {
    public static final String ID_PREFIX = "interpreter-";
    private static final String UNDEFINED = "Undefined interpreter";
    private String myInterpreterId;

    @Override
    @Attribute(value="interpreter_id")
    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    @Override
    public void setInterpreterId(@NotNull String interpreterId) {
        if (interpreterId == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(0);
        }
        this.myInterpreterId = interpreterId;
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId()) == null;
    }

    @Override
    @Nullable
    public PhpTestFrameworkConfiguration copyWithSettingsSource(@Nullable Project project) {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        PhpInterpreter interpreter = manager.findInterpreterById(this.getInterpreterId());
        if (interpreter == null) {
            return null;
        }
        PhpInterpreter projectLevel = interpreter.clone();
        projectLevel.setId(PhpInterpreter.getNextId());
        projectLevel.setIsProjectLevel(true);
        projectLevel.setName(manager.getUniqueName(interpreter.getName() + " (project level)"));
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName());
        if (info != null) {
            PhpInterpretersPhpInfoCacheImpl.getInstance(project).setPhpInfo(projectLevel.getName(), info);
        }
        manager.addInterpreter(projectLevel);
        PhpTestFrameworkBySdkConfiguration copy = this.copy();
        copy.setInterpreterId(projectLevel.getId());
        return copy;
    }

    @Override
    @NotNull
    public String getPresentableName(@Nullable Project project) {
        String name = PhpInterpretersManagerImpl.getInstance(project).findInterpreterName(this.getInterpreterId());
        String string = name == null ? UNDEFINED : name;
        if (string == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = ID_PREFIX + this.getInterpreterId();
        if (string == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PhpTestFrameworkBySdkConfiguration copy() {
        PhpTestFrameworkBySdkConfiguration configuration = new PhpTestFrameworkBySdkConfiguration();
        configuration.myInterpreterId = this.myInterpreterId;
        this.copyTo(configuration);
        PhpTestFrameworkBySdkConfiguration phpTestFrameworkBySdkConfiguration = configuration;
        if (phpTestFrameworkBySdkConfiguration == null) {
            PhpTestFrameworkBySdkConfiguration.$$$reportNull$$$0(3);
        }
        return phpTestFrameworkBySdkConfiguration;
    }

    @Override
    protected String serialize(@Nullable String path) {
        return path;
    }

    @Override
    protected String deserialize(@Nullable String path) {
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBySdkConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

