/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import java.util.Comparator;

public class PhpUmlVisibilityManager
extends AbstractUmlVisibilityManager {
    private static final VisibilityLevel[] levels = new VisibilityLevel[]{new VisibilityLevel(PhpModifier.Access.PUBLIC.toString()), new VisibilityLevel(PhpModifier.Access.PROTECTED.toString()), new VisibilityLevel(PhpModifier.Access.PRIVATE.toString(), "All")};
    private static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        int ind2;
        int ind1 = ArrayUtil.indexOf((Object[])levels, (Object)o1);
        return ind1 == (ind2 = ArrayUtil.indexOf((Object[])levels, (Object)o2)) ? 0 : (ind1 < 0 ? 1 : ind1 - ind2);
    };

    public VisibilityLevel[] getVisibilityLevels() {
        return levels;
    }

    public VisibilityLevel getVisibilityLevel(Object element) {
        if (element instanceof PhpElementWithModifier) {
            PhpModifier modifier = ((PhpElementWithModifier)element).getModifier();
            if (modifier.isPublic()) {
                return levels[0];
            }
            if (modifier.isProtected()) {
                return levels[1];
            }
            if (modifier.isPrivate()) {
                return levels[2];
            }
        }
        return null;
    }

    public Comparator<VisibilityLevel> getComparator() {
        return COMPARATOR;
    }
}

