/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.model.v2.ComposeFileModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class ComposeInspectionHelper {
    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            ComposeInspectionHelper.$$$reportNull$$$0(0);
        }
        return this.shouldVisitFile(holder.getFile()) ? ComposeFileModel.META_TYPE_PROVIDER : null;
    }

    protected boolean shouldVisitFile(@NotNull PsiFile file) {
        if (file == null) {
            ComposeInspectionHelper.$$$reportNull$$$0(1);
        }
        return file instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)file) && this.isKnownComposeVersion((YAMLFile)file);
    }

    protected boolean isKnownComposeVersion(@NotNull YAMLFile composeFile) {
        YAMLDocument document;
        YAMLValue psiVersion;
        if (composeFile == null) {
            ComposeInspectionHelper.$$$reportNull$$$0(2);
        }
        return (psiVersion = ComposeInspectionHelper.getComposeVersion(document = (YAMLDocument)ContainerUtil.getFirstItem((List)composeFile.getDocuments()))) != null && ComposeInspectionHelper.isCompose2x(psiVersion);
    }

    @Nullable
    protected static YAMLValue getComposeVersion(@Nullable YAMLDocument document) {
        return Optional.ofNullable(document).map(YAMLDocument::getTopLevelValue).map(o -> (YAMLMapping)ObjectUtils.tryCast((Object)o, YAMLMapping.class)).map(map -> map.getKeyValueByKey("version")).map(YAMLKeyValue::getValue).orElse(null);
    }

    protected static boolean isCompose2x(@NotNull YAMLValue value) {
        if (value == null) {
            ComposeInspectionHelper.$$$reportNull$$$0(3);
        }
        if (value instanceof YAMLScalar) {
            String version = ((YAMLScalar)value).getTextValue().trim();
            version = StringUtil.unquoteString((String)version, (char)'\'');
            version = StringUtil.unquoteString((String)version, (char)'\"');
            return version.startsWith("2");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeInspectionHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMetaTypeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldVisitFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isKnownComposeVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompose2x";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

