/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.SybaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SybaseIntermediateFacade;

public class AseJdbcHelper
extends JdbcHelperImpl {
    private static final Pattern ASE_VERSION_PATTERN = Pattern.compile("/" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN.pattern());
    private static final Set<String> SYBASE_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"int"});

    public AseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Sybase.RDBMS, version, connection);
    }

    public AseJdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            AseJdbcHelper.$$$reportNull$$$0(0);
        }
        SybaseIntermediateFacade sybaseIntermediateFacade = new SybaseIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)SybaseExceptionRecognizer.INSTANCE);
        if (sybaseIntermediateFacade == null) {
            AseJdbcHelper.$$$reportNull$$$0(1);
        }
        return sybaseIntermediateFacade;
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return AseJdbcHelper.extractVersion(version);
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            AseJdbcHelper.$$$reportNull$$$0(2);
        }
        if (value == null) {
            AseJdbcHelper.$$$reportNull$$$0(3);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            AseJdbcHelper.$$$reportNull$$$0(4);
        }
        if (e.typeName == null) {
            return;
        }
        if (SYBASE_UNLIMITED_TYPES.contains(e.typeName.toLowerCase(Locale.ENGLISH))) {
            e.length = -1;
        }
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            AseJdbcHelper.$$$reportNull$$$0(5);
        }
        if (product == null || !JdbcNativeUtil.detectString(product, "sybase") && !JdbcNativeUtil.detectString(product, "adaptive server") && !StringUtilRt.startsWithIgnoreCase((String)product, (String)"ase")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return AseJdbcHelper.create(delegate);
    }

    @NotNull
    private static AseJdbcHelper create(@NotNull Connection delegate) throws Exception {
        if (delegate == null) {
            AseJdbcHelper.$$$reportNull$$$0(6);
        }
        String versionStr = JdbcNativeUtil.getString(delegate, "select @@version");
        JdbcNativeUtil.logInfo("@@version: " + versionStr);
        AseJdbcHelper aseJdbcHelper = new AseJdbcHelper(AseJdbcHelper.extractVersion(versionStr), delegate);
        if (aseJdbcHelper == null) {
            AseJdbcHelper.$$$reportNull$$$0(7);
        }
        return aseJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, ASE_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/AseJdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/AseJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

