/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.SerializableDriverPropertyInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtilRt;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class RemoteDriverImpl
extends JdbcRemoteObject
implements RemoteDriver {
    private static final List<PropertyReplacement> REPLACEMENTS = Collections.singletonList(new MysqlReplacement("zeroDateTimeBehavior", Collections.singletonList(Couple.of((Object)"convertToNull", (Object)"CONVERT_TO_NULL"))));
    private final Driver myDelegate;

    protected RemoteDriverImpl(Driver delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteDriverImpl wrap(Driver delegate) {
        return delegate == null ? null : new RemoteDriverImpl(delegate);
    }

    public String getCastToClassName() {
        return Driver.class.getName();
    }

    @Override
    public RemoteConnection connect(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            Connection connection = this.myDelegate.connect(p1, this.replaceInvalidProperties(p2));
            if (connection == null) {
                return null;
            }
            JdbcHelperImpl helper = JdbcNativeUtil.detect(connection);
            return (RemoteConnection)((Object)this.export((Remote)((Object)helper.wrap(connection))));
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean acceptsURL(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.acceptsURL(p1);
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int getMajorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMajorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getMinorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMinorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            DriverPropertyInfo[] value = this.myDelegate.getPropertyInfo(p1, p2);
            DriverPropertyInfo[] result = new DriverPropertyInfo[value == null ? 0 : value.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new SerializableDriverPropertyInfo(value[i]);
            }
            return result;
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean jdbcCompliant() throws RemoteException {
        try {
            return this.myDelegate.jdbcCompliant();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void unreferenced() {
        System.exit(0);
    }

    private Properties replaceInvalidProperties(Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties result = properties;
        for (PropertyReplacement replacement : REPLACEMENTS) {
            if (!replacement.isActiveFor(this.myDelegate)) continue;
            result = replacement.replace(this.myDelegate, result);
        }
        return result;
    }

    private static class MysqlReplacement
    extends PropertyReplacement {
        MysqlReplacement(@NotNull String key, @NotNull List<Couple<String>> replacements) {
            if (key == null) {
                MysqlReplacement.$$$reportNull$$$0(0);
            }
            if (replacements == null) {
                MysqlReplacement.$$$reportNull$$$0(1);
            }
            super(key, replacements);
        }

        @Override
        boolean isActiveFor(@NotNull Driver driver) {
            if (driver == null) {
                MysqlReplacement.$$$reportNull$$$0(2);
            }
            return driver.getClass().getName().contains("mysql");
        }

        @Override
        @NotNull
        PropertyReplacement.Direction getDirection(@NotNull Driver driver) {
            int version;
            if (driver == null) {
                MysqlReplacement.$$$reportNull$$$0(3);
            }
            PropertyReplacement.Direction direction = (version = driver.getMajorVersion()) >= 8 ? PropertyReplacement.Direction.FORWARD : PropertyReplacement.Direction.BACKWARD;
            if (direction == null) {
                MysqlReplacement.$$$reportNull$$$0(4);
            }
            return direction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacements";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$MysqlReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$MysqlReplacement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isActiveFor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirection";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class PropertyReplacement {
        private final String myKey;
        private final List<Couple<String>> myReplacements;

        PropertyReplacement(@NotNull String key, @NotNull List<Couple<String>> replacements) {
            if (key == null) {
                PropertyReplacement.$$$reportNull$$$0(0);
            }
            if (replacements == null) {
                PropertyReplacement.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myReplacements = replacements;
        }

        @NotNull
        Properties replace(@NotNull Driver driver, @NotNull Properties properties) {
            String value;
            if (driver == null) {
                PropertyReplacement.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                PropertyReplacement.$$$reportNull$$$0(3);
            }
            if ((value = properties.getProperty(this.myKey)) == null) {
                Properties properties2 = properties;
                if (properties2 == null) {
                    PropertyReplacement.$$$reportNull$$$0(4);
                }
                return properties2;
            }
            final Direction direction = this.getDirection(driver);
            Couple replacement = (Couple)ContainerUtilRt.find(this.myReplacements, (Condition)new Condition<Couple<String>>(){

                public boolean value(Couple<String> couple) {
                    return value.equals(direction.from(couple));
                }
            });
            if (replacement != null) {
                properties.setProperty(this.myKey, direction.to((Couple<String>)replacement));
            }
            Properties properties3 = properties;
            if (properties3 == null) {
                PropertyReplacement.$$$reportNull$$$0(5);
            }
            return properties3;
        }

        abstract boolean isActiveFor(@NotNull Driver var1);

        @NotNull
        abstract Direction getDirection(@NotNull Driver var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum Direction {
            FORWARD{

                @Override
                @NotNull
                String from(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = (String)couple.first;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                String to(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    String string = (String)couple.second;
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "couple";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement$Direction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement$Direction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "from";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "to";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "from";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "to";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }
            ,
            BACKWARD{

                @Override
                @NotNull
                String from(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String string = FORWARD.to(couple);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                String to(@NotNull Couple<String> couple) {
                    if (couple == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    String string = FORWARD.from(couple);
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "couple";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement$Direction$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl$PropertyReplacement$Direction$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "from";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "to";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "from";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "to";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };


            @NotNull
            abstract String from(@NotNull Couple<String> var1);

            @NotNull
            abstract String to(@NotNull Couple<String> var1);
        }
    }
}

