/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseFederatedProvider;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.JdbcDrivers;
import org.jetbrains.dekaf.util.Providers;

public final class Dekaf {
    private final String[] cmdLineArgs;
    private final ArrayList<String> myJarNamesToLoad = new ArrayList();
    private String myConnectionString = null;
    private ClassLoader myDriversClassLoader = Dekaf.class.getClassLoader();
    private BaseFederatedProvider myProvider = null;
    private DBFacade myFacade = null;
    private int errors = 0;
    private static final String PRINT_INFO_TEMPLATE = "Connection info:\n\tRDBMS:          \t%s\n\tServer version: \t%s\n\tDriver version: \t%s\n\tDatabase name:  \t%s\n\tSchema name:    \t%s\n\tUser name:      \t%s\n";

    private Dekaf(String[] cmdLineArgs) {
        this.cmdLineArgs = cmdLineArgs;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Dekaf.printBanner();
            return;
        }
        Dekaf dekaf = new Dekaf(args);
        try {
            dekaf.run();
        }
        catch (Abort abort) {
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void run() {
        this.processArguments();
        this.loadJars();
        this.loadDrivers();
        this.connect();
        this.printInfo();
    }

    private void processArguments() {
        for (String argX : this.cmdLineArgs) {
            String arg = argX.trim();
            String argLo = arg.toLowerCase();
            if (argLo.startsWith("jdbc:")) {
                this.processArgumentJdbc(arg);
                continue;
            }
            if (argLo.startsWith("load:")) {
                this.processArgumentLoad(arg);
                continue;
            }
            this.error("Unexpected argument: %s", arg);
        }
        this.checkErrors();
    }

    private void processArgumentJdbc(@NotNull String arg) {
        if (this.myConnectionString == null) {
            this.myConnectionString = arg;
        } else {
            this.error("Too many connection string");
        }
    }

    private void processArgumentLoad(@NotNull String arg) {
        String[] jars;
        String jarsStr = arg.substring(5);
        for (String jar : jars = jarsStr.split(",")) {
            if (jar.length() >= 5 && jar.endsWith(".jar")) {
                this.myJarNamesToLoad.add(jar);
                continue;
            }
            this.error("Unknown how to load '%s'", jar);
        }
    }

    private void loadJars() {
        ArrayList<URL> jarUrlList = new ArrayList<URL>(this.myJarNamesToLoad.size());
        for (String jarName : this.myJarNamesToLoad) {
            File jarFile = new File(jarName);
            if (!jarFile.exists()) {
                this.error("Jar file to load doesn't exist: %s", jarFile.getPath());
                continue;
            }
            if (!jarFile.isFile()) {
                this.error("Jar file to load is not a file: %s", jarFile.getPath());
                continue;
            }
            try {
                jarUrlList.add(jarFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.error("Malformed jar name for jar %s (Exception: %s)", jarName, e.getMessage());
            }
        }
        int n = jarUrlList.size();
        if (n == 0) {
            return;
        }
        URL[] urls = jarUrlList.toArray(new URL[n]);
        try {
            this.myDriversClassLoader = new URLClassLoader(urls, Dekaf.class.getClassLoader());
        }
        catch (Exception e) {
            this.error("Failed to load jars. Exception %s with message %s", e.getClass().getSimpleName(), e.getMessage());
        }
    }

    private void loadDrivers() {
        if (this.myJarNamesToLoad.isEmpty()) {
            return;
        }
        Collection<Driver> loadedDrivers = Providers.loadAllProviders(Driver.class, this.myDriversClassLoader);
        ArrayList<Driver> drivers = new ArrayList<Driver>(loadedDrivers.size());
        for (Driver driver : loadedDrivers) {
            if (driver.getClass().getName().equals("sun.jdbc.odbc.JdbcOdbcDriver")) continue;
            driver.getMajorVersion();
            try {
                DriverManager.registerDriver(driver);
                drivers.add(driver);
            }
            catch (SQLException e) {
                this.error("Failed to register driver %s\n exception %s with message %s", driver.getClass().getName(), e.getClass().getName(), e.getMessage());
            }
        }
        JdbcDrivers.setPreferredDrivers(this.myDriversClassLoader, drivers);
    }

    private void connect() {
        String connectionString = this.myConnectionString;
        if (connectionString == null) {
            this.error("The connection string is not specified");
            throw new Abort();
        }
        this.myProvider = new BaseFederatedProvider();
        this.myProvider.initLocally();
        this.myFacade = this.myProvider.openFacade(connectionString, null, 1, true);
    }

    private void printInfo() {
        DBFacade facade = this.myFacade;
        assert (facade != null);
        ConnectionInfo info = facade.getConnectionInfo();
        Dekaf.say(PRINT_INFO_TEMPLATE, info.rdbmsName, info.serverVersion, info.driverVersion, info.databaseName, info.schemaName, info.userName);
    }

    static void printBanner() {
        String banner = "Dekaf                                       \nUsage: dekaf connection-string [load:jars]  \n";
        Dekaf.say(banner);
    }

    static void say(String template, Object ... args) {
        System.out.println(String.format(template, args));
    }

    static void say(String str) {
        System.out.println(str);
    }

    void error(String errTextTemplate, Object ... args) {
        this.error(String.format(errTextTemplate, args));
    }

    void error(String errText) {
        ++this.errors;
        System.err.printf(errText, new Object[0]);
    }

    private void checkErrors() throws Abort {
        if (this.errors > 0) {
            throw new Abort();
        }
    }

    private static class Abort
    extends RuntimeException {
        private Abort() {
        }
    }
}

