/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.NameAndClass;

public final class RowLayout<R>
implements Serializable {
    @NotNull
    public final Kind kind;
    @NotNull
    public final Class<R> rowClass;
    @NotNull
    public final Class commonComponentClass;
    @NotNull
    public final NameAndClass[] components;
    private final boolean portable;

    RowLayout(@NotNull Kind kind, @NotNull Class<R> rowClass, @NotNull Class commonComponentClass, @NotNull NameAndClass[] components) {
        this.kind = kind;
        this.rowClass = rowClass;
        this.commonComponentClass = commonComponentClass;
        this.components = components;
        switch (kind) {
            case EXISTENCE: 
            case ONE_VALUE: 
            case ARRAY: 
            case TUPLE: {
                this.portable = true;
                break;
            }
            case STRUCT: 
            case CLASS_BY_POSITIONS: {
                String className = rowClass.getName();
                this.portable = className.startsWith("java.") || className.startsWith("javax.");
                break;
            }
            default: {
                this.portable = false;
            }
        }
    }

    RowLayout(@NotNull Kind kind, @NotNull Class<R> rowClass, @NotNull Class commonComponentClass, Class ... componentClasses) {
        this(kind, rowClass, commonComponentClass, RowLayout.unnamedComponentsOf(componentClasses));
    }

    @NotNull
    private static NameAndClass[] unnamedComponentsOf(@NotNull Class[] componentClasses) {
        int n = componentClasses.length;
        NameAndClass[] components = new NameAndClass[n];
        for (int i = 0; i < n; ++i) {
            components[i] = new NameAndClass('#' + Integer.toString(i + 1), componentClasses[i]);
        }
        return components;
    }

    public boolean isPortable() {
        return this.portable;
    }

    public RowLayout<Object[]> makeIntermediateLayout() {
        return new RowLayout<Object[]>(Kind.TUPLE, Object[].class, this.commonComponentClass, this.components);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowLayout rowLayout = (RowLayout)o;
        if (this.kind != rowLayout.kind) {
            return false;
        }
        if (!this.rowClass.equals(rowLayout.rowClass)) {
            return false;
        }
        if (!this.commonComponentClass.equals(rowLayout.commonComponentClass)) {
            return false;
        }
        return Arrays.equals(this.components, rowLayout.components);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.rowClass.hashCode();
        result = 31 * result + this.commonComponentClass.hashCode();
        result = 31 * result + Arrays.hashCode(this.components);
        return result;
    }

    public String toString() {
        switch (this.kind) {
            case EXISTENCE: {
                return "existence";
            }
            case ONE_VALUE: {
                return this.commonComponentClass.getSimpleName();
            }
            case ARRAY: {
                return this.commonComponentClass.getSimpleName() + "[]";
            }
            case TUPLE: {
                return "TUPLE" + this.representComponents();
            }
            case STRUCT: {
                return this.rowClass + this.representComponents();
            }
            case CLASS_BY_POSITIONS: {
                return this.rowClass + "(positions)";
            }
        }
        return "???";
    }

    @NotNull
    private String representComponents() {
        int n = this.components.length;
        if (n == 0) {
            return "(no components)";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            b.append(i == 0 ? " (" : ", ");
            NameAndClass component = this.components[i];
            b.append(component.name).append(':').append(component.clazz.getSimpleName());
        }
        b.append(')');
        return b.toString();
    }

    public static enum Kind {
        EXISTENCE,
        ONE_VALUE,
        ARRAY,
        TUPLE,
        STRUCT,
        CLASS_BY_POSITIONS;

    }
}

