/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Strings;

public class Rewriters {
    public static StringOperator replace(final @NotNull String what, final @NotNull String with) {
        return new StringOperator(){

            @Override
            public String apply(String arg) {
                return Strings.replace(arg, what, with);
            }
        };
    }

    public static StringOperator replace(final @NotNull Map<String, String> map) {
        return new StringOperator(){

            @Override
            public String apply(String arg) {
                if (map.isEmpty()) {
                    return arg;
                }
                if (arg == null) {
                    return null;
                }
                boolean was = false;
                StringBuilder b = new StringBuilder(arg);
                for (Map.Entry entry : map.entrySet()) {
                    String what = (String)entry.getKey();
                    String with = (String)entry.getValue();
                    int p = b.indexOf(what);
                    while (p >= 0) {
                        b.replace(p, p + what.length(), with);
                        p = b.indexOf(what, p + with.length());
                        was = true;
                    }
                }
                return was ? b.toString() : arg;
            }
        };
    }
}

