/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.NameAndClass;

public abstract class Classes {
    public static <C> Constructor<C> defaultConstructorOf(@NotNull Class<C> cla\u00df) throws IllegalArgumentException {
        try {
            return cla\u00df.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The class \"%s\" has no default constructor", cla\u00df.getName()));
        }
    }

    public static NameAndClass[] assignableFieldsOf(@NotNull Class<?> clazz) {
        ArrayList<NameAndClass> fields = new ArrayList<NameAndClass>(8);
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isPrivate(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers)) continue;
            NameAndClass nac = new NameAndClass(field.getName(), field.getType());
            fields.add(nac);
        }
        int n = fields.size();
        return fields.toArray(new NameAndClass[n]);
    }
}

