/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Service;

public abstract class Providers {
    @NotNull
    public static <P> P loadProvider(@NotNull Class<P> providerClass) throws NoSuchProviderException {
        Iterator providersIterator = Service.providers(providerClass);
        if (!providersIterator.hasNext()) {
            throw new NoSuchProviderException("A provider named " + providerClass.getName() + " not found.");
        }
        Object provider = providersIterator.next();
        if (providerClass.isAssignableFrom(provider.getClass())) {
            return (P)provider;
        }
        String msg = String.format("The provider named %s is an instance of %s (not the requested class)", providerClass.getName(), provider.getClass().getName());
        throw new NoSuchProviderException(msg);
    }

    public static <P> Collection<P> loadAllProviders(@NotNull Class<P> serviceClass, @Nullable ClassLoader classLoader) {
        ClassLoader theClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        Iterator providersIterator = Service.providers(serviceClass, (ClassLoader)theClassLoader);
        LinkedList providers = new LinkedList();
        while (providersIterator.hasNext()) {
            Object p = providersIterator.next();
            if (!serviceClass.isAssignableFrom(p.getClass())) continue;
            providers.add(p);
        }
        return providers;
    }

    public static class NoSuchProviderException
    extends RuntimeException {
        private NoSuchProviderException(String message) {
            super(message);
        }
    }
}

