/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CellRendererPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class BasicNodeCellRenderer
implements NodeCellRenderer {
    private final Map<Pair<NodeRealizer, Boolean>, JComponent> myData = new HashMap<Pair<NodeRealizer, Boolean>, JComponent>();
    private final ModificationTracker myModificationTracker;
    private long myModificationCount = 0L;

    protected BasicNodeCellRenderer(ModificationTracker modificationTracker) {
        this.myModificationTracker = modificationTracker;
    }

    @Override
    public JComponent getNodeCellRendererComponent(Graph2DView graph2DView, NodeRealizer nodeRealizer, Object object, boolean b) {
        Pair key = Pair.create((Object)nodeRealizer, (Object)b);
        Map<Pair<NodeRealizer, Boolean>, JComponent> map = this.getData();
        JComponent component = map.get(key);
        boolean printMode = GraphViewUtil.isPrintMode();
        if (component == null || printMode) {
            JComponent renderer = this.getRendererComponent(graph2DView, nodeRealizer, object, b);
            CellRendererPanel.SuperValidate wrapper = new CellRendererPanel.SuperValidate();
            wrapper.setLayout((LayoutManager)new BorderLayout());
            wrapper.setFocusable(false);
            wrapper.add((Component)renderer, (Object)"Center");
            component = wrapper;
            map.put((Pair<NodeRealizer, Boolean>)key, component);
        }
        if (printMode) {
            this.myData.clear();
            for (JComponent c : UIUtil.findComponentsOfType((JComponent)component, JComponent.class)) {
                c.setBackground(Color.WHITE);
            }
        }
        return component;
    }

    private Map<Pair<NodeRealizer, Boolean>, JComponent> getData() {
        if (this.myModificationTracker == null) {
            this.clearCache();
        } else {
            long modificationCount = this.myModificationTracker.getModificationCount();
            if (this.myModificationCount != modificationCount) {
                this.clearCache();
                this.myModificationCount = modificationCount;
            }
        }
        return this.myData;
    }

    protected void clearCache() {
        this.myData.clear();
    }

    protected abstract JComponent getRendererComponent(Graph2DView var1, NodeRealizer var2, Object var3, boolean var4);
}

