/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ComposeServiceActionBase;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.util.ServerRuntimeException;

public class ComposeScaleAction
extends ComposeServiceActionBase {
    public ComposeScaleAction() {
        super("Scale", "Scale service", AllIcons.General.ExpandAll);
    }

    protected void doActionPerformed(DeploymentNode node) {
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        if (applicationRuntime == null) {
            return;
        }
        ComposeServiceRuntime serviceRuntime = (ComposeServiceRuntime)applicationRuntime;
        String scaleNumber = Messages.showInputDialog((String)"Number of containers:", (String)"Scale", null, (String)"1", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                Integer scaleValue;
                try {
                    scaleValue = Integer.parseInt(inputString);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return scaleValue > 0;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (scaleNumber == null) {
            return;
        }
        try {
            serviceRuntime.scaleService(Integer.parseInt(scaleNumber));
        }
        catch (ServerRuntimeException e) {
            this.handleServerRuntimeException(e);
        }
    }
}

