/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class DockerDeploymentEditorBase
extends SettingsEditor<DockerDeploymentConfiguration> {
    private final Project myProject;
    private String myUnsupportedJsonPath;

    public DockerDeploymentEditorBase(@NotNull Project project) {
        if (project == null) {
            DockerDeploymentEditorBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DockerDeploymentEditorBase.$$$reportNull$$$0(1);
        }
        return project;
    }

    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditorBase.$$$reportNull$$$0(2);
        }
        this.myUnsupportedJsonPath = configuration.getJSONFilePath();
    }

    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentEditorBase.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myUnsupportedJsonPath)) {
            throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerDeploymentEditorBase.error.json.file.is.not.supported", new Object[0]), () -> {
                if (configuration == null) {
                    DockerDeploymentEditorBase.$$$reportNull$$$0(5);
                }
                this.migrateUnsupportedJSONFile(configuration);
            });
        }
        configuration.setJSONFilePath(this.myUnsupportedJsonPath);
    }

    private void migrateUnsupportedJSONFile(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditorBase.$$$reportNull$$$0(4);
        }
        Optional.ofNullable(configuration.getJSONFilePath()).map(FileUtil::toSystemDependentName).map(arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByPath(arg_0)).ifPresent(vFile -> FileEditorManager.getInstance((Project)this.myProject).openFile(vFile, true));
        this.myUnsupportedJsonPath = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentEditorBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "migrateUnsupportedJSONFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyEditorTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class CommandPreviewField
    extends ExpandableTextField {
        private final ExternalSplitter mySplitter;

        public CommandPreviewField() {
            this(new ExternalSplitter());
        }

        public CommandPreviewField(ExternalSplitter splitter) {
            super((Function)splitter, ParametersListUtil.DEFAULT_LINE_JOINER);
            this.mySplitter = splitter;
        }

        public void setSplittedText(@NotNull List<String> split) {
            String text;
            boolean changed;
            if (split == null) {
                CommandPreviewField.$$$reportNull$$$0(0);
            }
            if (changed = this.mySplitter.setTextAndCustomSplit(text = (String)ParametersListUtil.DEFAULT_LINE_JOINER.fun(split), split)) {
                super.setText(text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "split", "com/intellij/docker/deployment/ui/DockerDeploymentEditorBase$CommandPreviewField", "setSplittedText"));
        }

        static class ExternalSplitter
        implements Function<String, List<String>> {
            private String myExpectedText;
            private List<String> myExpectedSplit;

            ExternalSplitter() {
            }

            public boolean setTextAndCustomSplit(@NotNull String expectedText, @NotNull List<String> expectedSplit) {
                boolean changed;
                if (expectedText == null) {
                    ExternalSplitter.$$$reportNull$$$0(0);
                }
                if (expectedSplit == null) {
                    ExternalSplitter.$$$reportNull$$$0(1);
                }
                boolean bl = changed = !expectedText.equals(this.myExpectedText);
                if (changed) {
                    this.myExpectedText = expectedText;
                    this.myExpectedSplit = expectedSplit;
                }
                return changed;
            }

            public List<String> fun(String text) {
                if (this.myExpectedText == null) {
                    throw new IllegalStateException("I am not ready to split anything");
                }
                if (!text.equals(this.myExpectedText)) {
                    throw new IllegalStateException("Expected to split: " + this.myExpectedText + "\n\t, actually asked to split: " + text);
                }
                return this.myExpectedSplit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expectedSplit";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditorBase$CommandPreviewField$ExternalSplitter";
                objectArray[2] = "setTextAndCustomSplit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

