/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.PostgresDialectHelper;
import com.intellij.database.dialects.generic.introspector.GenericIntrospector;
import com.intellij.database.dialects.postgresbase.model.PgBaseModRoutine;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.PgVolatilityKind;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericSourceLoader
implements GenericIntrospector.SourceLoader {
    private static final Logger LOG = Logger.getInstance(GenericSourceLoader.class);

    @Override
    public void loadSources(@NotNull Iterable<BasicModSourceAware> objects, @NotNull DatabaseConnection connection2) {
        if (objects == null) {
            GenericSourceLoader.$$$reportNull$$$0(0);
        }
        if (connection2 == null) {
            GenericSourceLoader.$$$reportNull$$$0(1);
        }
        Exception first = null;
        Exception last = null;
        int count2 = 0;
        BasicModSourceAware any = (BasicModSourceAware)Iterables.getFirst(objects, null);
        if (any == null) {
            return;
        }
        Dbms dbms = any.getModel().getDbms();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        for (BasicModSourceAware object : objects) {
            try {
                GenericSourceLoader.loadSource(dialect, object, connection2);
            }
            catch (Exception e) {
                object.setSourceText(null);
                if (first == null) {
                    first = e;
                } else {
                    last = e;
                }
                ++count2;
            }
        }
        if (count2 != 0) {
            LOG.warn("Failed to load: " + count2 + " sources.\nFirst exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)first, (Logger)LOG) + (last == null ? null : "Last exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)last, (Logger)LOG)));
        }
    }

    public static void loadSource(@NotNull DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection2) throws Exception {
        if (dialect == null) {
            GenericSourceLoader.$$$reportNull$$$0(2);
        }
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(3);
        }
        if (connection2 == null) {
            GenericSourceLoader.$$$reportNull$$$0(4);
        }
        ObjectKind k = object.getKind();
        ObjectKind p2 = DasUtil.getKind((DasObject)object.getParent());
        boolean wasSet = false;
        if (p2 == ObjectKind.PACKAGE && k == ObjectKind.BODY) {
            wasSet = GenericSourceLoader.loadPackage(dialect, object, connection2, true);
        } else if (k == ObjectKind.PACKAGE) {
            wasSet = GenericSourceLoader.loadPackage(dialect, object, connection2, false);
        } else if ((p2 == ObjectKind.SCHEMA || dialect.getDbms().isSybase() && p2 == ObjectKind.PACKAGE) && k == ObjectKind.ROUTINE) {
            wasSet = GenericSourceLoader.loadRoutine(dialect, object, connection2);
        } else if (p2 == ObjectKind.SCHEMA && k == ObjectKind.VIEW) {
            wasSet = GenericSourceLoader.loadView(dialect, object, connection2);
        }
        if (!wasSet) {
            object.setSourceText(null);
        }
    }

    private static boolean loadView(@NotNull DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection2) throws SQLException {
        if (dialect == null) {
            GenericSourceLoader.$$$reportNull$$$0(5);
        }
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            GenericSourceLoader.$$$reportNull$$$0(7);
        }
        if (!dialect.supportsViewDefinition() || !(object instanceof DasTable)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> query = dialect.sqlViewDefinition(object);
        StringBuilder res2 = new StringBuilder();
        DbImplUtil.concatStringResults(connection2, dbms, 0, (String)query.first, res2, (DbImplUtil.ConcatenationProps)query.second);
        if (res2.length() == 0) {
            return false;
        }
        GenericSourceLoader.applySourceText(object, res2, dbms.isMysql() || dbms.isH2() || dbms.isHsqldb() || dbms.isPostgres());
        return true;
    }

    private static boolean loadRoutine(@NotNull DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection2) throws Exception {
        if (dialect == null) {
            GenericSourceLoader.$$$reportNull$$$0(8);
        }
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(9);
        }
        if (connection2 == null) {
            GenericSourceLoader.$$$reportNull$$$0(10);
        }
        if (!dialect.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        if (dbms.isMysql()) {
            String src = DbImplUtil.concatStringResults(connection2, dbms, "select routine_definition from information_schema.routines where routine_name = " + PostgresDialectHelper.str(object.getName()) + "   and routine_schema = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)object)), 0, DbImplUtil.ConcatenationProps.NO_CONCAT);
            if (StringUtil.isEmpty((String)src)) {
                return false;
            }
            GenericSourceLoader.applySourceText(object, src, false);
            return true;
        }
        if (dbms.isPostgres() && object instanceof PgBaseModRoutine) {
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection2.getMetaData());
            Version curVersion = new Version(md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion(), 0);
            boolean hasUseful = curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(4));
            boolean isPre81 = !curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(1));
            PgBaseModRoutine routine = (PgBaseModRoutine)object;
            int limit = Math.max(10, routine.getArguments().size()) + 5;
            Boolean res2 = (Boolean)DbImplUtil.executeAndGetResult(connection2, "select " + (hasUseful ? "       pg_catalog.pg_get_function_arguments(pg_proc.oid) as arguments_def,\n       pg_catalog.pg_get_function_result(pg_proc.oid) as result_def,\n" : "       " + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ", " + PostgresDialectHelper.select(limit, isPre81) + "       pronargs,\n       proretset,\n") + "       prosrc,\n       lanname\nfrom pg_proc join pg_namespace nsp on nsp.oid = pronamespace left join pg_language l on l.oid = prolang\n" + (hasUseful ? "" : PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + " " + PostgresDialectHelper.join(limit, isPre81) + "\n") + "where proname = " + PostgresDialectHelper.str(object.getName()) + " and nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)object)) + "\n", rs -> {
                if (!rs.next()) {
                    return false;
                }
                if (hasUseful) {
                    routine.setArgumentsDefinition(StringUtil.nullize((String)rs.getString("arguments_def")));
                    routine.setResultsDefinition(StringUtil.nullize((String)rs.getString("result_def")));
                } else {
                    PostgresDialectHelper.SignatureBuilder sigBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                    DdlBuilder builder = new DdlBuilder().withDialect(DbImplUtil.getDatabaseDialect(Dbms.POSTGRES));
                    routine.setArgumentsDefinition(StringUtil.nullize((String)sigBuilder.buildArguments(builder).getStatement()));
                    builder.clear();
                    routine.setResultsDefinition(StringUtil.nullize((String)sigBuilder.buildReturn(builder).getStatement()));
                }
                routine.setSourceText(new SimpleCompositeText(rs.getString("prosrc"), CompositeText.Kind.ORIGINAL_TEXT));
                routine.setLanguageName(StringUtil.nullize((String)rs.getString("lanname")));
                if (dbms.isRedshift()) {
                    routine.setVolatilityKind(PgVolatilityKind.VOLATILE);
                }
                return true;
            });
            return res2 == Boolean.TRUE;
        }
        String source = dialect.tryToLoadProcedureDefinition((DasRoutine)object, connection2);
        if (StringUtil.isNotEmpty((String)source)) {
            GenericSourceLoader.applySourceText(object, source, dbms.isHsqldb());
            return true;
        }
        Pair<String, DbImplUtil.ConcatenationProps> query = dialect.sqlProcedureDefinition((DasRoutine)object);
        StringBuilder res3 = new StringBuilder();
        int length = res3.length();
        if ((res3 = DbImplUtil.concatStringResults(connection2, dbms, (String)query.first, 0, res3, (DbImplUtil.ConcatenationProps)query.second)).length() == length) {
            return false;
        }
        GenericSourceLoader.applySourceText(object, res3, dbms.isHsqldb());
        return true;
    }

    private static boolean loadPackage(DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection2, boolean body2) throws SQLException {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(11);
        }
        if (connection2 == null) {
            GenericSourceLoader.$$$reportNull$$$0(12);
        }
        if (dialect.supportsPackageDefinition()) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> query = body2 ? dialect.sqlPackageBodyDefinition(object) : dialect.sqlPackageDefinition(object);
        StringBuilder res2 = new StringBuilder("CREATE ");
        int length = res2.length();
        if (length == (res2 = DbImplUtil.concatStringResults(connection2, dbms, (String)query.first, 0, res2, (DbImplUtil.ConcatenationProps)query.second)).length()) {
            return false;
        }
        GenericSourceLoader.applySourceText(object, res2, false);
        return true;
    }

    private static void applySourceText(@NotNull BasicModSourceAware object, CharSequence text2, boolean format) {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(13);
        }
        if (text2 != null && text2.length() > 0) {
            SimpleCompositeText ct = new SimpleCompositeText(text2, format ? CompositeText.Kind.DECOMPILED_TEXT : CompositeText.Kind.ORIGINAL_TEXT);
            object.setSourceText(ct);
        } else {
            object.setSourceText(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/generic/introspector/GenericSourceLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSources";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSource";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadView";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRoutine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "applySourceText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Provider
    implements GenericIntrospector.SourceLoaderProvider {
        @Override
        @Nullable
        public GenericIntrospector.SourceLoader create(@NotNull DatabaseConnection connection2) {
            if (connection2 == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return new GenericSourceLoader();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/generic/introspector/GenericSourceLoader$Provider", "create"));
        }
    }
}

