/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SizeAndScale;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.h2.generator.H2NamingService;
import com.intellij.database.dialects.h2.generator.producers.H2AlterCheck;
import com.intellij.database.dialects.h2.generator.producers.H2AlterDatabase;
import com.intellij.database.dialects.h2.generator.producers.H2AlterForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2AlterIndex;
import com.intellij.database.dialects.h2.generator.producers.H2AlterKey;
import com.intellij.database.dialects.h2.generator.producers.H2AlterRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2AlterSchema;
import com.intellij.database.dialects.h2.generator.producers.H2AlterSequence;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTable;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2AlterTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2AlterView;
import com.intellij.database.dialects.h2.generator.producers.H2AlterViewColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateCheck;
import com.intellij.database.dialects.h2.generator.producers.H2CreateForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2CreateIndex;
import com.intellij.database.dialects.h2.generator.producers.H2CreateKey;
import com.intellij.database.dialects.h2.generator.producers.H2CreateLikeColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSchema;
import com.intellij.database.dialects.h2.generator.producers.H2CreateSequence;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTable;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2CreateTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2CreateView;
import com.intellij.database.dialects.h2.generator.producers.H2DropForeignKey;
import com.intellij.database.dialects.h2.generator.producers.H2DropIndex;
import com.intellij.database.dialects.h2.generator.producers.H2DropKey;
import com.intellij.database.dialects.h2.generator.producers.H2DropRoutine;
import com.intellij.database.dialects.h2.generator.producers.H2DropSchema;
import com.intellij.database.dialects.h2.generator.producers.H2DropSequence;
import com.intellij.database.dialects.h2.generator.producers.H2DropTable;
import com.intellij.database.dialects.h2.generator.producers.H2DropTableColumn;
import com.intellij.database.dialects.h2.generator.producers.H2DropTrigger;
import com.intellij.database.dialects.h2.generator.producers.H2DropView;
import com.intellij.database.dialects.h2.model.H2Check;
import com.intellij.database.dialects.h2.model.H2Database;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2Key;
import com.intellij.database.dialects.h2.model.H2LikeColumn;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.dialects.h2.model.H2Trigger;
import com.intellij.database.dialects.h2.model.H2View;
import com.intellij.database.dialects.h2.model.H2ViewColumn;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.script.generator.ScriptLocus;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u001c\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/h2/generator/H2ScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/dialects/base/generator/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "canGenerateHere", "", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "commentStr", "comment", "createAlterProducer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createDropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createProducer", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "getNamingService", "Lcom/intellij/database/dialects/h2/generator/H2NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects"})
public final class H2ScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes;
    public static final H2ScriptGeneratorHelper INSTANCE;

    @Override
    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return defaultPrimitiveSizes;
    }

    @Override
    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null || (string = ScriptGeneratorHelperKt.getSqlString(string)) == null) {
            string = "null";
        }
        return string;
    }

    @Override
    public boolean canGenerateHere(@NotNull ScriptingContext context, @NotNull ScriptLocus locus, @Nullable BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        if (locus == ScriptLocus.IN_COLUMN) {
            if (element2 instanceof H2ForeignKey && ScriptGeneratorHelperKt.useName((BasicNamedElement)element2, context)) {
                return false;
            }
            if (element2 instanceof H2Key && ((H2Key)element2).isPrimary() && ScriptGeneratorHelperKt.useName((BasicNamedElement)element2, context)) {
                return false;
            }
        }
        return super.canGenerateHere(context, locus, element2);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof H2Schema ? (CreateProducer)new H2CreateSchema(context, (H2Schema)element2) : (basicElement instanceof H2Sequence ? (CreateProducer)new H2CreateSequence(context, (H2Sequence)element2) : (basicElement instanceof H2Table ? (CreateProducer)new H2CreateTable(context, (H2Table)element2) : (basicElement instanceof H2Index ? (CreateProducer)new H2CreateIndex(context, (H2Index)element2) : (basicElement instanceof H2Trigger ? (CreateProducer)new H2CreateTrigger(context, (H2Trigger)element2) : (basicElement instanceof H2Key ? (CreateProducer)new H2CreateKey(context, (H2Key)element2) : (basicElement instanceof H2ForeignKey ? (CreateProducer)new H2CreateForeignKey(context, (H2ForeignKey)element2) : (basicElement instanceof H2Check ? (CreateProducer)new H2CreateCheck(context, (H2Check)element2) : (basicElement instanceof H2View ? (CreateProducer)new H2CreateView(context, (H2View)element2) : (basicElement instanceof H2TableColumn ? (CreateProducer)new H2CreateTableColumn(context, (H2TableColumn)element2) : (basicElement instanceof H2LikeColumn ? (CreateProducer)new H2CreateLikeColumn<H2LikeColumn>(context, (H2LikeColumn)element2) : (basicElement instanceof H2Routine ? (CreateProducer)new H2CreateRoutine(context, (H2Routine)element2) : super.createProducer(context, element2))))))))))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof H2Schema ? (DropProducer)new H2DropSchema(context, (H2Schema)element2) : (basicElement instanceof H2Table ? (DropProducer)new H2DropTable(context, (H2Table)element2) : (basicElement instanceof H2TableColumn ? (DropProducer)new H2DropTableColumn(context, (H2TableColumn)element2) : (basicElement instanceof H2Key ? (DropProducer)new H2DropKey(context, (H2Key)element2) : (basicElement instanceof H2ForeignKey ? (DropProducer)new H2DropForeignKey(context, (H2ForeignKey)element2) : (basicElement instanceof H2Index ? (DropProducer)new H2DropIndex(context, (H2Index)element2) : (basicElement instanceof H2Sequence ? (DropProducer)new H2DropSequence(context, (H2Sequence)element2) : (basicElement instanceof H2Trigger ? (DropProducer)new H2DropTrigger(context, (H2Trigger)element2) : (basicElement instanceof H2View ? (DropProducer)new H2DropView(context, (H2View)element2) : (basicElement instanceof H2Routine ? (DropProducer)new H2DropRoutine(context, (H2Routine)element2) : super.createDropProducer(context, element2))))))))));
    }

    @Override
    @NotNull
    public AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Object obj;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Object obj2 = it = (obj = elements.getSourceElement());
        return obj2 instanceof H2Database ? (AlterProducer)new H2AlterDatabase(context, (ElementAlteration<? extends H2Database>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Schema ? (AlterProducer)new H2AlterSchema(context, (ElementAlteration<? extends H2Schema>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2View ? (AlterProducer)new H2AlterView(context, (ElementAlteration<? extends H2View>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Table ? (AlterProducer)new H2AlterTable(context, (ElementAlteration<? extends H2Table>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Index ? (AlterProducer)new H2AlterIndex(context, (ElementAlteration<? extends H2Index>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2ForeignKey ? (AlterProducer)new H2AlterForeignKey(context, (ElementAlteration<? extends H2ForeignKey>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Key ? (AlterProducer)new H2AlterKey(context, (ElementAlteration<? extends H2Key>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Check ? (AlterProducer)new H2AlterCheck(context, (ElementAlteration<? extends H2Check>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2TableColumn ? (AlterProducer)new H2AlterTableColumn(context, (ElementAlteration<? extends H2TableColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2ViewColumn ? (AlterProducer)new H2AlterViewColumn(context, (ElementAlteration<? extends H2ViewColumn>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Routine ? (AlterProducer)new H2AlterRoutine(context, (ElementAlteration<? extends H2Routine>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Sequence ? (AlterProducer)new H2AlterSequence(context, (ElementAlteration<? extends H2Sequence>)BaseProducersKt.cast(elements, it)) : (obj2 instanceof H2Trigger ? (AlterProducer)new H2AlterTrigger(context, (ElementAlteration<? extends H2Trigger>)BaseProducersKt.cast(elements, it)) : super.createAlterProducer(context, elements)))))))))))));
    }

    @Override
    @NotNull
    public H2NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
        return H2NamingService.INSTANCE;
    }

    private H2ScriptGeneratorHelper() {
        Dbms dbms = Dbms.H2;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"H2");
        super(dbms);
    }

    static {
        H2ScriptGeneratorHelper h2ScriptGeneratorHelper;
        INSTANCE = h2ScriptGeneratorHelper = new H2ScriptGeneratorHelper();
        defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"boolean", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"tinyint", (Object)new SizeAndScale(3, 0, 2, null)), TuplesKt.to((Object)"smallint", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"integer", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"bigint", (Object)new SizeAndScale(19, 0, 2, null)), TuplesKt.to((Object)"real", (Object)new SizeAndScale(7, 0, 2, null)), TuplesKt.to((Object)"double", (Object)new SizeAndScale(17, 0, 2, null)), TuplesKt.to((Object)"date", (Object)new SizeAndScale(8, 0, 2, null)), TuplesKt.to((Object)"time", (Object)new SizeAndScale(6, 0, 2, null)), TuplesKt.to((Object)"timestamp", (Object)new SizeAndScale(23, 10)), TuplesKt.to((Object)"timestamp with timezone", (Object)new SizeAndScale(30, 10)), TuplesKt.to((Object)"blob", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null)), TuplesKt.to((Object)"clob", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null))});
    }
}

