/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlitePlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private boolean myNewFmt;
    private final List<PlanRow> myRows;
    private final TIntObjectHashMap<MetaNode> myStructure;
    private int myMaxId;

    public SqlitePlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement) {
        if (owner == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer2, EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST, PlanModel.Feature.NUM_ROWS));
        this.myRows = ContainerUtil.newArrayList();
        this.myStructure = new TIntObjectHashMap();
        this.myMaxId = 0;
        this.myStatement = statement;
    }

    private void getData(final @NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(3);
        }
        SqlitePlanModelBuilder.useStatementWithPreserved(connection2, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                DatabaseMetaData md = connection2.getMetaData();
                SqlitePlanModelBuilder.this.myNewFmt = md == null || Version.of((String)md.getDatabaseProductVersion()).isOrGreater(new int[]{3, 24});
                statement.noisy().execute("EXPLAIN QUERY PLAN " + SqlitePlanModelBuilder.this.myStatement, SqlitePlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (rs.getMetaData().getColumnCount() != 4) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    while (rs.next()) {
                        SqlitePlanModelBuilder.this.myRows.add(new PlanRow(rs.getInt(SqlitePlanModelBuilder.this.myNewFmt ? "id" : "selectid"), rs.getInt(SqlitePlanModelBuilder.this.myNewFmt ? "parent" : "order"), rs.getInt(3), rs.getString("detail")));
                    }
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
    }

    @Override
    @NotNull
    protected String dump() {
        StringBuilder sb = new StringBuilder();
        for (PlanRow row : this.myRows) {
            sb.append("\t").append(row.subqueryId).append("\t").append(row.order).append("\t").append(row.from).append("\t").append(row.detail).append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void processDump(@NotNull String dump) {
        if (dump == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(5);
        }
        this.parseDump(dump);
        this.processData();
    }

    private void parseDump(String dump) {
        this.myRows.clear();
        for (String line : dump.split("\\r?\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 5);
            this.myRows.add(new PlanRow(Integer.parseInt((String)split.get(1)), Integer.parseInt((String)split.get(2)), Integer.parseInt((String)split.get(3)), (String)split.get(4)));
        }
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.getData(connection2);
        this.showRaw();
        this.processData();
    }

    private void processData() {
        this.parseStructure();
        this.cacheNodes();
        this.openNode();
        MetaNode root2 = (MetaNode)this.myStructure.get(0);
        this.parseStatement(root2);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.modelReady();
    }

    private void cacheNodes() {
        this.openNode();
        TIntObjectIterator it = this.myStructure.iterator();
        while (it.hasNext()) {
            it.advance();
            this.parseSubPlans((MetaNode)it.value());
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        this.resetRoot();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(8);
        }
        if ("" == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @NotNull
    private PlanModel.GenericNode buildConstantScanNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(13);
        }
        if (!SqlitePlanModelBuilder.checkOrRecover(tok, "ROW")) {
            this.consumeToken(tok, "ROWS");
        }
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.VALUE, "CONSTANT ROWS");
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericAccessNode buildTableScanNode(@NotNull ListIterator<String> tok) {
        PlanModel.GenericAccessNode res2;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(15);
        }
        String tableName = tok.next();
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "AS")) {
            tok.next();
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            PlanModel.IndexScanNode node = (PlanModel.IndexScanNode)this.createNode(null, PlanModel.NodeType.INDEX_SCAN, null);
            res2 = node;
            if (SqlitePlanModelBuilder.checkOrRecover(tok, "INTEGER")) {
                this.consumeTokens(tok, "PRIMARY", "KEY");
            } else if (SqlitePlanModelBuilder.checkOrRecover(tok, "PRIMARY")) {
                this.consumeTokens(tok, "KEY");
            } else {
                String token = tok.next();
                if ("AUTOMATIC".equals(token)) {
                    token = tok.next();
                }
                if ("COVERING".equals(token)) {
                    token = tok.next();
                }
                this.checkToken(token, "INDEX");
                String indexName = tok.next();
                node.setIndex(indexName);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(", "=?)")) {
                tok.next();
            }
        } else {
            res2 = (PlanModel.GenericAccessNode)this.createNode(null, PlanModel.NodeType.SEQ_SCAN, null);
        }
        res2.setRelation(tableName);
        PlanModel.GenericAccessNode genericAccessNode = res2;
        if (genericAccessNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(16);
        }
        return genericAccessNode;
    }

    @NotNull
    private PlanModel.GenericNode buildScanNode(@NotNull ListIterator<String> tok) {
        String token;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(17);
        }
        if (ObjectPaths.isNumber(token = tok.next())) {
            this.consumeToken(tok, "CONSTANT");
            PlanModel.GenericNode genericNode = this.buildConstantScanNode(tok);
            if (genericNode == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(18);
            }
            return genericNode;
        }
        if (token.equals("CONSTANT")) {
            PlanModel.GenericNode genericNode = this.buildConstantScanNode(tok);
            if (genericNode == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(19);
            }
            return genericNode;
        }
        if (token.equals("TABLE")) {
            PlanModel.GenericAccessNode genericAccessNode = this.buildTableScanNode(tok);
            if (genericAccessNode == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(20);
            }
            return genericAccessNode;
        }
        this.checkToken("SUBQUERY", token);
        PlanModel.GenericNode genericNode = this.buildSubqueryScanNode(tok);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(21);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildSubqueryScanNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(22);
        }
        if (!this.myNewFmt) {
            this.parseSubquery(Integer.parseInt(tok.next()), true);
        }
        PlanModel.GenericNode genericNode = this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(23);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull MetaNode state, @NotNull ListIterator<String> tok) {
        PlanModel.GenericNode genericNode;
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(24);
        }
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(25);
        }
        try {
            PlanModel.GenericNode node;
            String token = tok.next();
            if ("SCAN".equals(token) || "SEARCH".equals(token)) {
                node = this.buildScanNode(tok);
            } else if ("EXECUTE".equals(token) || "LEFT-MOST".equals(token)) {
                node = this.buildSubqueryNode(tok);
            } else if (this.myNewFmt && ("CORRELATED".equals(token) || "SCALAR".equals(token) || "LIST".equals(token) || "SUBQUERY".equals(token))) {
                tok.previous();
                node = this.buildSubqueryNode(tok);
            } else if ("COMPOUND".equals(token)) {
                node = this.buildCompoundNode(tok);
            } else if ("USE".equals(token)) {
                node = this.buildUseNode(tok);
            } else {
                PlanRow row = state.rowId == -1 ? null : this.myRows.get(state.rowId);
                PlanModel.GenericNode genericNode2 = node = this.myNewFmt && row != null ? this.buildOperationNode(row.detail) : this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            }
            if (SqlitePlanModelBuilder.checkPrefSufAndRecover(tok, "(~", null)) {
                node.setPlanNumRows(new BigDecimal(tok.next().substring(2)));
                this.consumeToken(tok, "rows)");
            }
            genericNode = node;
        }
        catch (NoSuchElementException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode3 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode3 == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(27);
            }
            return genericNode3;
        }
        catch (NumberFormatException e) {
            this.unsupportedFormat(e, null);
            PlanModel.GenericNode genericNode4 = this.createNode(null, PlanModel.NodeType.UNKNOWN, null);
            if (genericNode4 == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(28);
            }
            return genericNode4;
        }
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(26);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNewCompoundNode(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(29);
        }
        PlanModel.GenericNode genericNode = this.buildNewCompoundChildNode(state, state.children.size() - 1);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(30);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildNewCompoundChildNode(@NotNull MetaNode compound, int idx) {
        if (compound == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(31);
        }
        MetaNode node = compound.children.get(idx);
        PlanModel.GenericNode res2 = this.buildNode(node);
        if (idx > 1) {
            this.addLazyNode((Getter<PlanModel.GenericNode>)((Getter)() -> {
                if (compound == null) {
                    SqlitePlanModelBuilder.$$$reportNull$$$0(62);
                }
                return this.buildNewCompoundChildNode(compound, idx - 1);
            }), false);
        } else {
            this.buildNewCompoundOneChildNode(compound.children.get(0));
        }
        this.buildNewCompoundOneChildNode(node);
        PlanModel.GenericNode genericNode = res2;
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(32);
        }
        return genericNode;
    }

    private void buildNewCompoundOneChildNode(MetaNode node) {
        if (node.children.size() != 1) {
            this.unsupportedFormat("Expected one child, got " + node.children.size());
        }
        this.parsePlan(node.children.get(0));
    }

    @NotNull
    private PlanModel.GenericNode buildUseNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(33);
        }
        this.consumeTokens(tok, "TEMP", "B-TREE", "FOR");
        String op = tok.next();
        while (tok.hasNext()) {
            op = op + " " + tok.next();
        }
        PlanModel.NodeType type = TYPE_MAPPING.get(op);
        if (type == null) {
            type = PlanModel.NodeType.TRANSFORM;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.TRANSFORM ? op : null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(34);
        }
        return genericNode;
    }

    @NotNull
    private PlanModel.GenericNode buildCompoundNode(@NotNull ListIterator<String> tok) {
        PlanModel.NodeType type;
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(35);
        }
        this.consumeToken(tok, "SUBQUERIES");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        this.consumeToken(tok, "AND");
        this.parseSubquery(Integer.parseInt(tok.next()), false);
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "USING")) {
            this.consumeTokens(tok, "TEMP", "B-TREE");
        }
        String token = "";
        while (tok.hasNext()) {
            token = token + " " + tok.next();
        }
        if (!(token = token.trim()).startsWith("(") && token.endsWith(")")) {
            this.unsupportedFormat(token);
        }
        if ((type = TYPE_MAPPING.get(token = token.substring(1, token.length() - 1))) == null) {
            type = PlanModel.NodeType.SET_OP;
        }
        PlanModel.GenericNode genericNode = this.createNode(null, type, type == PlanModel.NodeType.SET_OP ? token : null);
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(36);
        }
        return genericNode;
    }

    private PlanModel.GenericNode buildSubqueryNode(@NotNull ListIterator<String> tok) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(37);
        }
        boolean scalar = false;
        boolean correlated = false;
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "CORRELATED")) {
            correlated = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "SCALAR")) {
            scalar = true;
        }
        if (SqlitePlanModelBuilder.checkOrRecover(tok, "LIST")) {
            // empty if block
        }
        this.consumeToken(tok, "SUBQUERY");
        if (!this.myNewFmt) {
            this.parseSubquery(Integer.parseInt(tok.next()), false);
        }
        PlanModel.SubQueryNode res2 = (PlanModel.SubQueryNode)this.createNode(null, PlanModel.NodeType.SUBQUERY, null);
        res2.setCorrelated(correlated);
        res2.setScalar(scalar);
        return res2;
    }

    private PlanModel.GenericNode buildOperationNode(@NotNull String details) {
        int idx;
        String desc;
        PlanModel.NodeType op;
        if (details == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(38);
        }
        if ((op = TYPE_MAPPING.get(desc = (idx = details.indexOf("USING")) < 1 ? details : details.substring(0, idx - 1))) == null && (idx = details.indexOf(" ")) != -1) {
            desc = details.substring(0, idx);
            op = TYPE_MAPPING.get(desc);
        }
        return this.createNode(null, (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)op), (Object)((Object)PlanModel.NodeType.UNKNOWN))), op == null ? null : desc);
    }

    private static boolean checkOrRecover(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(39);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(40);
        }
        if (tok.hasNext()) {
            if (tok.next().equals(token)) {
                return true;
            }
            tok.previous();
        }
        return false;
    }

    private static boolean checkPrefSufAndRecover(@NotNull ListIterator<String> tok, @Nullable String prefix, @Nullable String suffix) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(41);
        }
        if (tok.hasNext()) {
            String token = tok.next();
            tok.previous();
            if ((prefix == null || token.startsWith(prefix)) && (suffix == null || token.endsWith(suffix))) {
                return true;
            }
        }
        return false;
    }

    private void checkToken(@NotNull String current, @NotNull String token) {
        if (current == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(42);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(43);
        }
        if (!token.equals(current)) {
            this.unsupportedFormat("unexpected " + current + " != " + token);
        }
    }

    private void consumeToken(@NotNull ListIterator<String> tok, @NotNull String token) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(44);
        }
        if (token == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(45);
        }
        this.checkToken(tok.next(), token);
    }

    private void consumeTokens(@NotNull ListIterator<String> tok, String ... tokens) {
        if (tok == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(46);
        }
        if (tokens == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(47);
        }
        for (String s : tokens) {
            this.consumeToken(tok, s);
        }
    }

    @Nullable
    private MetaNode removeSubquery(int id, boolean byteOverflow) {
        MetaNode node;
        MetaNode metaNode = node = id == 0 && byteOverflow ? null : (MetaNode)this.myStructure.get(id);
        if (byteOverflow) {
            while (node == null && id < this.myMaxId) {
                node = (MetaNode)this.myStructure.get(id += 256);
            }
        }
        return node != null ? (MetaNode)this.myStructure.remove(id) : null;
    }

    private void parseSubquery(int id, boolean byteOverflow) {
        MetaNode node = this.removeSubquery(id, byteOverflow);
        if (node == null) {
            node = new MetaNode(id, MetaNode.Type.DUMMY);
            node.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myMaxId = Math.max(this.myMaxId, id);
        }
        this.parseSubPlans(node);
    }

    @Override
    protected void parsePlan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(48);
        }
        assert (state.type != MetaNode.Type.DUMMY);
        this.addLazyNode((Getter<PlanModel.GenericNode>)((Getter)() -> {
            PlanModel.GenericNode node;
            if (state == null) {
                SqlitePlanModelBuilder.$$$reportNull$$$0(61);
            }
            if (state.cache != null) {
                return state.cache;
            }
            boolean compound = this.isCompound(state);
            if (compound) {
                node = this.buildNewCompoundNode(state);
            } else if (state.type == MetaNode.Type.NESTED) {
                node = this.createNode(state, PlanModel.NodeType.NESTED_LOOPS, null);
            } else if (state.type == MetaNode.Type.TEMP) {
                node = this.createNode(state, PlanModel.NodeType.TEMPORARY, null);
            } else if (state.type == MetaNode.Type.SIMPLE) {
                node = this.createNode(state, PlanModel.NodeType.VALUE, null);
            } else {
                assert (state.type == MetaNode.Type.ROW);
                node = this.buildNode(state);
            }
            if (!compound) {
                this.parseSubPlans(state);
            }
            state.cache = node;
            return node;
        }), this.isScan(state));
    }

    private boolean isCompound(@NotNull @NotNull @NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(49);
        }
        boolean compound = false;
        if (state.rowId != -1) {
            PlanRow row = this.myRows.get(state.rowId);
            compound = row.detail.startsWith("COMPOUND");
        }
        return compound;
    }

    @NotNull
    private PlanModel.GenericNode buildNode(@NotNull MetaNode state) {
        PlanModel.GenericNode node;
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(50);
        }
        PlanRow curRow = this.myRows.get(state.rowId);
        try {
            node = this.buildNode(state, Arrays.asList(curRow.detail.split(" ")).listIterator());
        }
        catch (PlanRetrievalException e) {
            throw new PlanRetrievalException("while building for" + curRow.detail, e);
        }
        node.setRawDescription(curRow.detail);
        PlanModel.GenericNode genericNode = node;
        if (genericNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(51);
        }
        return genericNode;
    }

    private boolean isScan(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(52);
        }
        if (state.type != MetaNode.Type.ROW) {
            return false;
        }
        PlanRow curRow = this.myRows.get(state.rowId);
        return StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SCAN") || StringUtil.startsWithIgnoreCase((String)curRow.detail, (String)"SEARCH");
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode state) {
        if (state == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(53);
        }
        for (MetaNode child : state.children) {
            this.parsePlan(child);
        }
    }

    private void parseStructure() {
        if (!this.myRows.isEmpty()) {
            if (this.myNewFmt) {
                for (int i2 = 0; i2 < this.myRows.size(); ++i2) {
                    MetaNode node = new MetaNode(i2, MetaNode.Type.ROW);
                    this.myStructure.put(this.myRows.get((int)i2).subqueryId, (Object)node);
                }
                for (PlanRow row : this.myRows) {
                    MetaNode parent2 = (MetaNode)this.myStructure.get(row.order);
                    if (parent2 == null) {
                        parent2 = new MetaNode(-1, MetaNode.Type.DUMMY);
                        this.myStructure.put(row.order, (Object)parent2);
                    }
                    parent2.children.add((MetaNode)this.myStructure.get(row.subqueryId));
                }
            } else {
                for (PlanRow row : this.myRows) {
                    if (this.myStructure.containsKey(row.subqueryId)) continue;
                    MetaNode node = new MetaNode(-1, MetaNode.Type.DUMMY);
                    node.children.addAll(this.parseSubqueryStructure(row.subqueryId));
                    this.myStructure.put(row.subqueryId, (Object)node);
                    this.myMaxId = Math.max(this.myMaxId, row.subqueryId);
                }
            }
        } else {
            MetaNode value = new MetaNode(0, MetaNode.Type.DUMMY);
            value.children.add(new MetaNode(-1, MetaNode.Type.SIMPLE));
            this.myStructure.put(0, (Object)value);
        }
    }

    @NotNull
    private MetaNode expandStructure(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(54);
        }
        if (node.type == MetaNode.Type.ROW && this.myRows.get((int)node.rowId).detail.contains("TEMP B-TREE")) {
            boolean child = this.myRows.get((int)node.rowId).detail.startsWith("USING");
            MetaNode temp = new MetaNode(-1, MetaNode.Type.TEMP);
            if (child) {
                temp.children.addAll(node.children);
                node.children.clear();
                node.children.add(temp);
            } else {
                temp.children.add(node);
                node = temp;
            }
        }
        MetaNode metaNode = node;
        if (metaNode == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(55);
        }
        return metaNode;
    }

    private List<MetaNode> parseSubqueryStructure(int id) {
        ArrayList res2;
        List<Object> toPutScalarSubqueries = res2 = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < this.myRows.size(); ++i2) {
            if (this.myRows.get((int)i2).subqueryId != id || this.myRows.get((int)i2).order != 0) continue;
            MetaNode node = this.parseNestedStructure(i2);
            if (!res2.isEmpty() && this.myRows.get((int)i2).detail.startsWith("EXECUTE")) {
                toPutScalarSubqueries.add(node);
                continue;
            }
            node.children.addAll(res2);
            if (toPutScalarSubqueries == res2) {
                toPutScalarSubqueries = node.children;
            }
            res2.clear();
            res2.add(this.expandStructure(node));
        }
        return res2;
    }

    private MetaNode parseNestedStructure(int idx) {
        ArrayList res2 = ContainerUtil.newArrayList();
        int i2 = idx;
        int depth = 0;
        while (i2 < this.myRows.size() && this.myRows.get((int)i2).subqueryId == this.myRows.get((int)idx).subqueryId) {
            if (depth != this.myRows.get((int)i2).order) {
                if (this.myRows.get((int)i2).order == 0) break;
                this.unsupportedFormat(null);
            }
            res2.add(new MetaNode(i2, MetaNode.Type.ROW));
            ++i2;
            ++depth;
        }
        if (res2.size() == 1) {
            return (MetaNode)res2.get(0);
        }
        MetaNode nested = new MetaNode(-1, MetaNode.Type.NESTED);
        nested.children.addAll(res2);
        return nested;
    }

    @Override
    protected void parseStatement(@NotNull MetaNode s) {
        String[] split;
        if (s == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(56);
        }
        this.openNode();
        PlanModel.NodeType type = PlanModel.NodeType.STATEMENT;
        if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"select") || StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"with")) {
            type = PlanModel.NodeType.SELECT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"update")) {
            type = PlanModel.NodeType.UPDATE;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"insert")) {
            type = PlanModel.NodeType.INSERT;
        } else if (StringUtil.startsWithIgnoreCase((String)this.myStatement, (String)"delete")) {
            type = PlanModel.NodeType.DELETE;
        }
        if (!this.myRows.isEmpty()) {
            this.parseSubPlans(s);
        }
        String title = null;
        if (type == PlanModel.NodeType.STATEMENT && (split = this.myStatement.split(" ")).length > 0) {
            title = StringUtil.toLowerCase((String)split[0]);
        }
        this.closeNode(this.createNode(s, type, title));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(57);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(58);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(59);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode node) {
        if (node == null) {
            SqlitePlanModelBuilder.$$$reportNull$$$0(60);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNION ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("EXCEPT", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("INTERSECT", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("GROUP BY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("ORDER BY", PlanModel.NodeType.ORDER_BY);
        TYPE_MAPPING.put("DISTINCT", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("MATERIALIZE", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("CO-ROUTINE", PlanModel.NodeType.OPERATION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sqlite/plan/SqlitePlanModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 22: 
            case 25: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tok";
                break;
            }
            case 31: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compound";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 40: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sqlite/plan/SqlitePlanModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConstantScanNode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTableScanNode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildScanNode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubqueryScanNode";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewCompoundNode";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewCompoundChildNode";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUseNode";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCompoundNode";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "expandStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: 
            case 55: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDump";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildConstantScanNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildTableScanNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildScanNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryScanNode";
                break;
            }
            case 24: 
            case 25: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "buildNode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildNewCompoundNode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildNewCompoundChildNode";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildUseNode";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildCompoundNode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildSubqueryNode";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildOperationNode";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkOrRecover";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefSufAndRecover";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkToken";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "consumeToken";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "consumeTokens";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isCompound";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isScan";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "expandStructure";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parsePlan$1";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildNewCompoundChildNode$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MetaNode {
        public final int rowId;
        public final Type type;
        public final List<MetaNode> children = ContainerUtil.newArrayListWithCapacity((int)0);
        public PlanModel.GenericNode cache = null;

        public MetaNode(int id, Type type) {
            this.rowId = id;
            this.type = type;
        }

        static enum Type {
            ROW,
            NESTED,
            DUMMY,
            TEMP,
            SIMPLE;

        }
    }

    public static class PlanRow {
        public final int subqueryId;
        public final int order;
        public final int from;
        public final String detail;

        public PlanRow(int subqueryId, int order, int from, String detail) {
            this.subqueryId = subqueryId;
            this.order = order;
            this.from = from;
            this.detail = detail;
        }
    }
}

