/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.intellij.database.introspection.LongIdName;
import java.sql.Timestamp;
import java.util.List;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class AseIntroQueries {
    static final AseIntroQueries QUERIES = new AseIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(AseIntroQueries.class);
    final SqlQuery<Timestamp> now = this.myScriptum.query("Now", Layouts.singleOf(Timestamp.class));
    final SqlQuery<List<LongIdName>> listDatabases = this.myScriptum.query("ListDatabases", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<List<LongIdName>> listSchemas = this.myScriptum.query("ListSchemas", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<SortedMap<Integer, String>> retrieveSchemas = this.myScriptum.query("RetrieveSchemas", Layouts.sortedMapOf(Integer.class, String.class));
    final SqlQuery<List<OneMajorName>> retrieveMajorNames = this.myScriptum.query("RetrieveMajorNames", Layouts.listOf((RowLayout)Layouts.structOf(OneMajorName.class)));
    final SqlQuery<List<OneProcedure>> retrieveProcedures = this.myScriptum.query("RetrieveProcedures", Layouts.listOf((RowLayout)Layouts.structOf(OneProcedure.class)));
    final SqlQuery<List<OneColumnOrArgument>> retrieveColumnsAndArguments = this.myScriptum.query("RetrieveColumnsAndArguments", Layouts.listOf((RowLayout)Layouts.structOf(OneColumnOrArgument.class)));
    final SqlQuery<List<OneDefault>> retrieveDefaults = this.myScriptum.query("RetrieveDefaults", Layouts.listOf((RowLayout)Layouts.structOf(OneDefault.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneForeignKey>> retrieveForeignKeys = this.myScriptum.query("RetrieveForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(OneForeignKey.class)));
    final SqlQuery<List<int[]>> retrieveForeignKeysWideColumnLists = this.myScriptum.query("RetrieveForeignKeysWideColumnLists", Layouts.listOf((RowLayout)Layouts.arrayOfInts()));
    final SqlQuery<List<OneCheck>> retrieveChecks = this.myScriptum.query("RetrieveChecks", Layouts.listOf((RowLayout)Layouts.structOf(OneCheck.class)));
    final SqlQuery<List<OneTrigger>> retrieveTriggers = this.myScriptum.query("RetrieveTriggers", Layouts.listOf((RowLayout)Layouts.structOf(OneTrigger.class)));
    final SqlQuery<List<OneSource>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.listOf((RowLayout)Layouts.structOf(OneSource.class)));
    final SqlQuery<List<OneState>> retrieveStates = this.myScriptum.query("RetrieveStates", Layouts.listOf((RowLayout)Layouts.structOf(OneState.class)));

    static final class OneState
    implements Cloneable {
        int object_id;
        int state_nr;

        OneState() {
        }
    }

    static final class OneSource
    implements Cloneable {
        char major_kind;
        char minor_kind;
        int major_id;
        int minor_id;
        String text;

        OneSource() {
        }
    }

    static final class OneTrigger {
        int table_id;
        int trig_id;
        String trig_name;
        int state_nr;
        char event_code;
        char turn_code;

        OneTrigger() {
        }
    }

    static final class OneCheck {
        int table_id;
        int constraint_id;
        String constraint_name;
        String definition;
        short column_position;

        OneCheck() {
        }
    }

    static final class OneForeignKey {
        int source_constraint_id;
        int source_table_id;
        int target_table_id;
        short target_index_position;
        short involved_columns_count;
        String source_constraint_name;
        short column_position_1;
        short column_position_2;
        short column_position_3;
        short column_position_4;

        OneForeignKey() {
        }
    }

    static final class OneIndex {
        int id;
        short position;
        String name;
        short bits1;
        short bits2;
        Object keys1;
        Object keys2;

        OneIndex() {
        }
    }

    static final class OneDefault {
        int id;
        short position;
        String text;

        OneDefault() {
        }
    }

    static final class OneColumnOrArgument {
        int id;
        short procedure_position;
        short colid;
        String name;
        String type_name;
        int length;
        boolean variable;
        short prec;
        short scale;
        short bits1;
        short bits2;

        OneColumnOrArgument() {
        }
    }

    static final class OneProcedure {
        int id;
        short procedure_position;

        OneProcedure() {
        }
    }

    static final class OneMajorName {
        int id;
        char type;
        String name;
        int state_nr;

        OneMajorName() {
        }
    }
}

