/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.Dbms;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.serialization.YaDocument;
import com.intellij.database.model.serialization.YaElement;
import com.intellij.database.model.serialization.YaModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\bJ.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/serialization/YaExporter;", "", "()V", "export", "Lcom/intellij/database/model/serialization/YaModel;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "withSurrogate", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "exportChildren", "", "Lcom/intellij/database/model/serialization/YaElement;", "followSchemas", "exportDocument", "Lcom/intellij/database/model/serialization/YaDocument;", "headElement", "exportElement", "exportHeadAndSchemas", "", "yaModel", "head", "schemas", "", "Lcom/intellij/database/model/basic/BasicSchema;", "exportProperties", "", "", "intellij.database.impl"})
public final class YaExporter {
    @NotNull
    public final YaModel export(@NotNull BasicModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
        return this.export(basicRoot, true);
    }

    @NotNull
    public final YaModel export(@NotNull BasicElement element2, boolean withSurrogate) {
        Dbms dbms;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        YaModel yaModel = new YaModel(null, 1, null);
        Object object = element2;
        if (object instanceof BasicRoot) {
            Iterable<? extends BasicSchema> iterable = ((BasicRoot)element2).getAllSchemas();
            Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"element.allSchemas");
            this.exportHeadAndSchemas(yaModel, element2, iterable, withSurrogate);
        } else if (object instanceof BasicDatabase) {
            NamingFamily<? extends BasicSchema> namingFamily = ((BasicDatabase)element2).getSchemas();
            Intrinsics.checkExpressionValueIsNotNull(namingFamily, (String)"element.schemas");
            this.exportHeadAndSchemas(yaModel, element2, (Iterable<? extends BasicSchema>)namingFamily, withSurrogate);
        } else {
            YaDocument document = this.exportDocument(element2, true, withSurrogate);
            yaModel.getDocuments().add(document);
        }
        object = yaModel.getDocuments();
        boolean bl2 = bl = !object.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Must be exported at least one document";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        BasicModel basicModel = element2.getModel();
        Object object2 = dbms = basicModel != null ? basicModel.getDbms() : null;
        if (dbms != null) {
            Map<String, Object> map = ((YaDocument)CollectionsKt.first(yaModel.getDocuments())).getProperties();
            String string = "Dbms";
            String string2 = dbms.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dbms.name");
            String string3 = string2;
            map.put(string, string3);
        }
        return yaModel;
    }

    private final void exportHeadAndSchemas(YaModel yaModel, BasicElement head, Iterable<? extends BasicSchema> schemas2, boolean withSurrogate) {
        YaDocument headDocument = this.exportDocument(head, false, withSurrogate);
        yaModel.getDocuments().add(headDocument);
        for (BasicSchema basicSchema : schemas2) {
            if (!basicSchema.isVisible()) continue;
            YaDocument schemaDocument = this.exportDocument(basicSchema, true, withSurrogate);
            yaModel.getDocuments().add(schemaDocument);
        }
    }

    private final YaDocument exportDocument(BasicElement headElement, boolean followSchemas, boolean withSurrogate) {
        YaElement head = this.exportElement(headElement, followSchemas, withSurrogate);
        YaDocument document = new YaDocument(null, head, 1, null);
        BasicElement basicElement = headElement;
        if (!(basicElement instanceof BasicRoot)) {
            if (basicElement instanceof BasicDatabase) {
                String databaseName = ((BasicDatabase)headElement).getRealName();
                if (databaseName != null) {
                    Map<String, Object> map = document.getProperties();
                    String string = "databaseName";
                    String string2 = databaseName;
                    map.put(string, string2);
                }
            } else if (basicElement instanceof BasicSchema) {
                String schemaName;
                String string;
                Object object;
                String databaseName;
                BasicDatabase basicDatabase = ((BasicSchema)headElement).getDatabase();
                String string3 = databaseName = basicDatabase != null ? basicDatabase.getRealName() : null;
                if (databaseName != null) {
                    Map<String, Object> map = document.getProperties();
                    object = "databaseName";
                    string = databaseName;
                    map.put((String)object, string);
                }
                if ((schemaName = ((BasicSchema)headElement).getRealName()) != null) {
                    object = document.getProperties();
                    string = "schemaName";
                    String string4 = schemaName;
                    object.put(string, string4);
                }
            }
        }
        return document;
    }

    static /* synthetic */ YaDocument exportDocument$default(YaExporter yaExporter, BasicElement basicElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return yaExporter.exportDocument(basicElement, bl, bl2);
    }

    @NotNull
    public final YaElement exportElement(@NotNull BasicElement element2, boolean followSchemas, boolean withSurrogate) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String kindCode = element2.getKind().code();
        Map<String, Object> properties = this.exportProperties(element2, withSurrogate);
        List<YaElement> children2 = this.exportChildren(element2, followSchemas, withSurrogate);
        String string = kindCode;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"kindCode");
        return new YaElement(string, properties, children2);
    }

    @NotNull
    public static /* synthetic */ YaElement exportElement$default(YaExporter yaExporter, BasicElement basicElement, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return yaExporter.exportElement(basicElement, bl, bl2);
    }

    @NotNull
    public final Map<String, Object> exportProperties(@NotNull BasicElement element2, boolean withSurrogate) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        LinkedHashMap map = new LinkedHashMap();
        element2.exportProperties(new NameValueConsumer<String>(map){
            final /* synthetic */ LinkedHashMap $map;

            public final void accept(@NotNull String name, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Map map = this.$map;
                String string = value;
                map.put(name, string);
            }
            {
                this.$map = linkedHashMap;
            }
        });
        if (element2 instanceof BasicNamedElement && ((BasicNamedElement)element2).isNameSurrogate() && !withSurrogate) {
            map.remove("Name");
        }
        return map;
    }

    private final List<YaElement> exportChildren(BasicElement element2, boolean followSchemas, boolean withSurrogate) {
        ArrayList<YaElement> children2 = new ArrayList<YaElement>();
        if (element2.hasChildren() && (!(element2 instanceof BasicSchema) || followSchemas)) {
            Iterator iterator = element2.getChildren().iterator();
            while (iterator.hasNext()) {
                BasicElement child;
                BasicElement basicElement = child = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                YaElement y = this.exportElement(basicElement, followSchemas, withSurrogate);
                children2.add(y);
            }
        }
        return children2;
    }
}

