/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DbCustomUsageSearcher
extends CustomUsageSearcher
implements UsageTypeProvider {
    private static final UsageType SCHEMA_USAGE_TYPE = new UsageType(DatabaseMessages.message((String)"usage.type.schema", (Object[])new Object[0]));

    public void processElementUsages(@NotNull PsiElement element2, @NotNull Processor<Usage> processor, @NotNull FindUsagesOptions options) {
        if (element2 == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(2);
        }
        if (element2 instanceof SqlFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)element2.getProject()).getDataSources()) {
                DatabaseSystem delegate = dataSource.getDelegate();
                if (!(delegate instanceof SqlDataSource) || !((SqlDataSource)delegate).getFiles().contains(virtualFile) || processor.process((Object)new MyUsage(dataSource.getName(), (DbElement)dataSource))) continue;
                return;
            }
            return;
        }
        DasObject target = DbUtil.getDasObject((Object)element2);
        if (target == null || !(element2 instanceof DbElement)) {
            return;
        }
        DbElement dbTarget = (DbElement)element2;
        if (DbSqlUtil.isSqlElement(dbTarget)) {
            return;
        }
        DbDataSource dataSource = dbTarget.getDataSource();
        ObjectKind targetKind = target.getKind();
        if (targetKind == ObjectKind.NONE) {
            return;
        }
        JBTreeTraverser traverser2 = dataSource.getDelegate().getModel().traverser();
        for (DasObject o : traverser2) {
            DbElement oo;
            ProgressManager.checkCanceled();
            if (!DbCustomUsageSearcher.referencesTarget(o, target, targetKind) || processor.process((Object)DbCustomUsageSearcher.createUsage(oo = DbImplUtil.findElement(dataSource, o), dbTarget))) continue;
            return;
        }
    }

    public UsageType getUsageType(PsiElement element2) {
        if (element2 instanceof DbElement) {
            return SCHEMA_USAGE_TYPE;
        }
        return null;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate, @NotNull DasObject target, @NotNull ObjectKind targetKind) {
        if (candidate == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(3);
        }
        if (target == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(4);
        }
        if (targetKind == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(5);
        }
        if (targetKind == ObjectKind.TABLE) {
            DasTable refTable;
            if (candidate instanceof DasForeignKey && target.equals(refTable = ((DasForeignKey)candidate).getRefTable())) {
                return true;
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DasConstraint) {
                if (ContainerUtil.find((Iterable)((DasConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                    return true;
                }
                if (candidate instanceof DasForeignKey && ContainerUtil.find((Iterable)((DasForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target) != null) {
                    return true;
                }
            } else if (candidate instanceof DasIndex && ContainerUtil.find((Iterable)((DasIndex)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                return true;
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target) {
            return true;
        }
        return candidate instanceof BasicElement && target instanceof BasicElement && Iterables.contains(((BasicElement)candidate).getPredecessors(), (Object)target);
    }

    private static Usage createUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        if (o == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(6);
        }
        if (resolveTo == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(7);
        }
        return new MyUsage(o, resolveTo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementUsages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "referencesTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUsage
    implements PsiElementUsage,
    UsagePresentation {
        final TextChunk[] myChunks;
        final String myText;
        final DbElement myO;
        final DbElement myNavigateTo;

        MyUsage(@NotNull String text2, @NotNull DbElement element2) {
            if (text2 == null) {
                MyUsage.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                MyUsage.$$$reportNull$$$0(1);
            }
            this.myText = text2;
            this.myO = this.myNavigateTo = element2;
            this.myChunks = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), this.myText)};
        }

        MyUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
            DasTypedObject keyColumn;
            if (o == null) {
                MyUsage.$$$reportNull$$$0(2);
            }
            if (resolveTo == null) {
                MyUsage.$$$reportNull$$$0(3);
            }
            TextAttributes emptyAttrs = new TextAttributes();
            TextAttributes boldAttrs = new TextAttributes(null, null, null, null, 1);
            ArrayList chunks = ContainerUtil.newArrayList();
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)DbSqlUtil.getSqlDialect(o), (Project)o.getProject(), null);
            Lexer lexer = highlighter.getHighlightingLexer();
            String text2 = DatabaseEditorHelper.generateDefinition(o, new StringBuilder()).toString();
            lexer.start((CharSequence)text2);
            EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
            String name = resolveTo.getName();
            while (lexer.getTokenType() != null) {
                IElementType type = lexer.getTokenType();
                TextAttributesKey[] keys = highlighter.getTokenHighlights(type);
                TextAttributes attributes = name.equalsIgnoreCase(lexer.getTokenText()) ? boldAttrs : (keys.length > 0 ? scheme.getAttributes(keys[0]) : emptyAttrs);
                chunks.add(new TextChunk(attributes, lexer.getTokenText()));
                lexer.advance();
            }
            this.myO = o;
            if (StringUtil.isNotEmpty((String)text2)) {
                this.myText = text2;
            } else {
                this.myText = DbPresentation.getPresentableName((DasObject)o, true);
                chunks.add(new TextChunk(emptyAttrs, this.myText));
            }
            DbElement navigateTo = o instanceof DbForeignKey ? ((keyColumn = (DasTypedObject)Iterables.getFirst((Iterable)((DbForeignKey)o).getRefColumns().resolveObjects(), null)) instanceof DbElement ? (DbElement)keyColumn : this.myO.getParent()) : o;
            chunks.add(new TextChunk(SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), " (" + QNameUtil.getQualifiedName(this.myO.getParent()) + ")"));
            this.myChunks = chunks.toArray(TextChunk.EMPTY_ARRAY);
            this.myNavigateTo = navigateTo;
        }

        @NotNull
        public UsagePresentation getPresentation() {
            MyUsage myUsage = this;
            if (myUsage == null) {
                MyUsage.$$$reportNull$$$0(4);
            }
            return myUsage;
        }

        public boolean isValid() {
            return this.myO.isValid() && this.myNavigateTo.isValid();
        }

        public boolean isReadOnly() {
            return true;
        }

        public FileEditorLocation getLocation() {
            return null;
        }

        public void selectInEditor() {
        }

        public void highlightInEditor() {
        }

        public void navigate(boolean requestFocus) {
            DatabaseView databaseView = DatabaseView.getDatabaseView(this.myNavigateTo.getProject());
            DatabaseViewOptions viewOptions = databaseView.getViewOptions();
            if (this.myO instanceof DbDataSource) {
                DatabaseView.select((PsiElement)this.myO, requestFocus);
            } else if (!viewOptions.HIDDEN_KINDS.contains(this.myO.getKind().code())) {
                this.myO.navigate(requestFocus);
            } else {
                this.myNavigateTo.navigate(requestFocus);
            }
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public PsiElement getElement() {
            return this.myO;
        }

        public boolean isNonCodeUsage() {
            return true;
        }

        @NotNull
        public TextChunk[] getText() {
            if (this.myChunks == null) {
                MyUsage.$$$reportNull$$$0(5);
            }
            return this.myChunks;
        }

        @NotNull
        public String getPlainText() {
            String string = this.myText;
            if (string == null) {
                MyUsage.$$$reportNull$$$0(6);
            }
            return string;
        }

        public Icon getIcon() {
            return this.myO.getIcon();
        }

        public String getTooltipText() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveTo";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlainText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

